/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GracefullyShutdown {
    public String shutdownName();

    public void shutdown() throws Throwable;

    default public int shutdownOrder() {
        return 0;
    }

    public static class Registry {
        private static final Logger log = LoggerFactory.getLogger(Registry.class);
        private Map<String, GracefullyShutdown> gracefullyShutdownMap = new HashMap<String, GracefullyShutdown>();
        private static final Registry SINGLETON = new Registry();

        public static Registry singleton() {
            return SINGLETON;
        }

        public void register(GracefullyShutdown gracefullyShutdown) {
            this.gracefullyShutdownMap.put(gracefullyShutdown.shutdownName(), gracefullyShutdown);
        }

        public boolean contains(String name) {
            return this.gracefullyShutdownMap.containsKey(name);
        }

        public Collection<String> names() {
            return new HashSet<String>(this.gracefullyShutdownMap.keySet());
        }

        public void shutdownRegistered() {
            if (this.gracefullyShutdownMap.isEmpty()) {
                return;
            }
            ArrayList<GracefullyShutdown> gracefullyShutdowns = new ArrayList<GracefullyShutdown>(this.gracefullyShutdownMap.values());
            gracefullyShutdowns.sort(Comparator.comparingInt(GracefullyShutdown::shutdownOrder));
            for (GracefullyShutdown gracefullyShutdown : gracefullyShutdowns) {
                if (log.isInfoEnabled()) {
                    log.info("gracefully shutdown name:[{}] of class:[{}]", (Object)gracefullyShutdown.shutdownName(), (Object)gracefullyShutdown.getClass().getSimpleName());
                }
                try {
                    gracefullyShutdown.shutdown();
                }
                catch (Throwable e) {
                    log.error("ex on gracefully shutdown name:[{}] of class:[{}]", new Object[]{gracefullyShutdown.shutdownName(), gracefullyShutdown.getClass().getSimpleName(), e});
                }
            }
            log.info("gracefully shutdown completed.");
        }
    }
}

