/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.limiter;

import io.github.icodegarden.commons.lang.limiter.RateLimiter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CounterRateLimiterSupport
implements RateLimiter {
    private static final Logger log = LoggerFactory.getLogger(CounterRateLimiterSupport.class);
    private long interval;
    private volatile long lastResetTime;

    public CounterRateLimiterSupport(long interval) {
        if (interval <= 0L) {
            throw new IllegalArgumentException("interval must gt 0");
        }
        this.interval = interval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAllowable(int weight) {
        long now = System.currentTimeMillis();
        if (now > this.lastResetTime + this.interval) {
            CounterRateLimiterSupport counterRateLimiterSupport = this;
            synchronized (counterRateLimiterSupport) {
                if (now > this.lastResetTime + this.interval) {
                    this.resetToken();
                    this.lastResetTime = now;
                }
            }
        }
        if (this.getAndDecrement(weight) < weight) {
            if (log.isInfoEnabled()) {
                log.info("{}:{} not allowed", (Object)CounterRateLimiterSupport.class.getSimpleName(), (Object)this.getName());
            }
            return false;
        }
        return true;
    }

    protected abstract void resetToken();

    protected abstract int getAndDecrement(int var1);
}

