/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.metrics;

import io.github.icodegarden.commons.lang.metrics.InstanceMetrics;
import io.github.icodegarden.commons.lang.metrics.Metrics;
import io.github.icodegarden.commons.lang.metrics.MetricsOverload;
import io.github.icodegarden.commons.lang.metrics.OverloadCalc;
import io.github.icodegarden.commons.lang.registry.InstanceRegistry;
import io.github.icodegarden.commons.lang.registry.RegisteredInstance;
import io.github.icodegarden.commons.lang.util.ThreadPoolUtils;
import java.io.IOException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMetricsOverload
implements MetricsOverload {
    private static final Logger log = LoggerFactory.getLogger(DefaultMetricsOverload.class);
    private final ScheduledThreadPoolExecutor scheduleFlushMetricsThreadPool = ThreadPoolUtils.newSingleScheduledThreadPool("DefaultMetricsOverload-scheduleFlushMetrics");
    private final InstanceRegistry<? extends RegisteredInstance> instanceRegistry;
    private final InstanceMetrics<? extends Metrics> instanceMetrics;
    private Metrics metrics;
    private long lastFlushTimestamp;
    private boolean scheduleFlushMetrics;

    public DefaultMetricsOverload(InstanceRegistry<? extends RegisteredInstance> instanceRegistry, InstanceMetrics<? extends Metrics> instanceMetrics, Metrics metrics) {
        this.instanceRegistry = instanceRegistry;
        this.instanceMetrics = instanceMetrics;
        this.metrics = metrics;
    }

    public void resetMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableScheduleFlushMetrics(long scheduleMillis) {
        DefaultMetricsOverload defaultMetricsOverload = this;
        synchronized (defaultMetricsOverload) {
            if (!this.scheduleFlushMetrics) {
                this.scheduleFlushMetricsThreadPool.scheduleWithFixedDelay(() -> {
                    block2: {
                        try {
                            this.flushMetricsIfNecessary(scheduleMillis);
                        }
                        catch (Throwable e) {
                            if (!log.isWarnEnabled()) break block2;
                            log.warn("ex on flushMetricsIfNecessary", e);
                        }
                    }
                }, 0L, scheduleMillis, TimeUnit.MILLISECONDS);
                this.scheduleFlushMetrics = true;
            }
        }
    }

    @Override
    public Metrics getMetrics() {
        RegisteredInstance instance = this.instanceRegistry.getRegistered();
        if (instance == null) {
            instance = this.instanceRegistry.registerIfNot();
            this.flushMetrics();
        }
        return this.instanceMetrics.getMetrics(instance);
    }

    @Override
    public Metrics getLocalMetrics() {
        return this.metrics;
    }

    @Override
    public boolean willOverload(OverloadCalc calc) {
        if (this.metrics.isOverload()) {
            return true;
        }
        Metrics.Dimension dimension = this.metrics.getDimension(Metrics.DimensionName.Jobs);
        return dimension.getUsed() + calc.ofOverload() > dimension.getMax();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean incrementOverload(OverloadCalc calc) {
        DefaultMetricsOverload defaultMetricsOverload = this;
        synchronized (defaultMetricsOverload) {
            if (this.willOverload(calc)) {
                return false;
            }
            boolean changed = this.metrics.incrementDimension(Metrics.DimensionName.Jobs, calc.ofOverload());
            return true;
        }
    }

    @Override
    public void decrementOverload(OverloadCalc calc) {
        boolean changed = this.metrics.decrementDimension(Metrics.DimensionName.Jobs, calc.ofOverload());
    }

    @Override
    public void flushMetrics() {
        this.metrics.refreshUsedValues();
        RegisteredInstance instance = this.instanceRegistry.registerIfNot();
        this.instanceMetrics.setMetrics(instance, this.metrics);
        this.lastFlushTimestamp = System.currentTimeMillis();
    }

    private void flushMetricsIfNecessary(long scheduleMillis) {
        if (System.currentTimeMillis() - scheduleMillis > this.lastFlushTimestamp) {
            this.flushMetrics();
        }
    }

    @Override
    public void close() throws IOException {
        this.scheduleFlushMetricsThreadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduleFlushMetricsThreadPool.shutdown();
    }
}

