/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.schedule;

import io.github.icodegarden.commons.lang.concurrent.lock.DistributedLock;
import io.github.icodegarden.commons.lang.schedule.GracefullyShutdownSchedule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LockSupportSchedule
extends GracefullyShutdownSchedule {
    private static final Logger log = LoggerFactory.getLogger(LockSupportSchedule.class);
    protected final DistributedLock lock;
    private long acquireLockTimeoutMillis = 1000L;

    public LockSupportSchedule(DistributedLock lock) {
        this.lock = lock;
    }

    public void setAcquireLockTimeoutMillis(long acquireLockTimeoutMillis) {
        this.acquireLockTimeoutMillis = acquireLockTimeoutMillis;
    }

    @Override
    protected void doSchedule() throws Throwable {
        if (this.lock.acquire(this.acquireLockTimeoutMillis)) {
            try {
                this.doScheduleAfterLocked();
            }
            finally {
                this.lock.release();
            }
        } else if (log.isInfoEnabled() && this.allowLoopLog()) {
            log.info("{} acquire lock false", (Object)this.getClass().getSimpleName());
        }
    }

    protected abstract void doScheduleAfterLocked() throws Throwable;

    @Override
    public void close() {
        super.close();
        if (this.lock.isAcquired()) {
            this.lock.release();
        }
    }
}

