/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ClassUtils {
    public static List<Class<?>> getGenericInterfaceTypes(Object target, Class<?> interfaceCla) {
        return ClassUtils.getGenericInterfaceTypes(target.getClass(), interfaceCla);
    }

    public static List<Class<?>> getGenericInterfaceTypes(Class<?> target, Class<?> interfaceCla) {
        ParameterizedType pt = ClassUtils.getGenericInterfaceParameterizedType(target, interfaceCla);
        if (pt != null) {
            LinkedList list = new LinkedList();
            for (Type type : pt.getActualTypeArguments()) {
                list.add((Class)type);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static ParameterizedType getGenericInterfaceParameterizedType(Object target, Class<?> interfaceCla) {
        return ClassUtils.getGenericInterfaceParameterizedType(target.getClass(), interfaceCla);
    }

    public static ParameterizedType getGenericInterfaceParameterizedType(Class<?> target, Class<?> interfaceCla) {
        Type[] genericInterfaces;
        if (target.equals(Object.class)) {
            return null;
        }
        for (Type genericInterface : genericInterfaces = target.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(interfaceCla)) continue;
            return (ParameterizedType)genericInterface;
        }
        return ClassUtils.getGenericInterfaceParameterizedType(target.getSuperclass(), interfaceCla);
    }
}

