/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import io.github.icodegarden.commons.lang.annotation.Nullable;
import io.github.icodegarden.commons.lang.util.SystemUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import org.springframework.scheduling.support.CronExpression;

public abstract class CronUtils {
    public static boolean isValid(@Nullable String cron) {
        return CronExpression.isValidExpression((String)cron);
    }

    public static long betweenMillis(String cron) {
        CronExpression cronExpression = CronExpression.parse((String)cron);
        LocalDateTime now = SystemUtils.now();
        LocalDateTime next = (LocalDateTime)cronExpression.next((Temporal)now);
        LocalDateTime next_next = (LocalDateTime)cronExpression.next((Temporal)next);
        Duration between = Duration.between(next, next_next);
        return between.toMillis();
    }

    public static long nextDelayMillis(String cron) {
        LocalDateTime now = SystemUtils.now();
        LocalDateTime next = CronUtils.next(cron);
        Duration between = Duration.between(now, next);
        return between.toMillis();
    }

    public static LocalDateTime next(String cron) {
        CronExpression cronExpression = CronExpression.parse((String)cron);
        LocalDateTime now = SystemUtils.now();
        return (LocalDateTime)cronExpression.next((Temporal)now);
    }
}

