/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class ExceptionUtils {
    private ExceptionUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(Throwable e) {
        UnsafeStringWriter w = new UnsafeStringWriter();
        p.println();
        try (PrintWriter p = new PrintWriter(w);){
            e.printStackTrace(p);
            String string = e.getMessage() != null ? e.getMessage() + w.toString() : w.toString();
            return string;
        }
    }

    public static <E extends Exception> E causeOf(Throwable t, Class<E> causeOf) {
        int counter = 0;
        for (Throwable cause = t; cause != null && counter++ < 10; cause = cause.getCause()) {
            if (!causeOf.isAssignableFrom(cause.getClass())) continue;
            return (E)((Exception)cause);
        }
        return null;
    }

    private static class UnsafeStringWriter
    extends Writer {
        private StringBuilder mBuffer = new StringBuilder();

        public UnsafeStringWriter() {
            this.lock = this.mBuffer;
        }

        @Override
        public void write(int c) {
            this.mBuffer.append((char)c);
        }

        @Override
        public void write(char[] cs) throws IOException {
            this.mBuffer.append(cs, 0, cs.length);
        }

        @Override
        public void write(char[] cs, int off, int len) throws IOException {
            if (off < 0 || off > cs.length || len < 0 || off + len > cs.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len > 0) {
                this.mBuffer.append(cs, off, len);
            }
        }

        @Override
        public void write(String str) {
            this.mBuffer.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            this.mBuffer.append(str, off, off + len);
        }

        @Override
        public Writer append(CharSequence csq) {
            if (csq == null) {
                this.write("null");
            } else {
                this.write(csq.toString());
            }
            return this;
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) {
            CharSequence cs = csq == null ? "null" : csq;
            this.write(cs.subSequence(start, end).toString());
            return this;
        }

        @Override
        public Writer append(char c) {
            this.mBuffer.append(c);
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        public String toString() {
            return this.mBuffer.toString();
        }
    }
}

