/*
 * Decompiled with CFR 0.152.
 */
package io.github.icodegarden.commons.lang.util;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import io.github.icodegarden.commons.lang.query.NextQuerySupportArrayList;
import io.github.icodegarden.commons.lang.query.NextQuerySupportPage;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class PageHelperUtils {
    public static boolean isPage() {
        Page page = PageHelper.getLocalPage();
        return page != null;
    }

    public static boolean isCount() {
        Page page = PageHelper.getLocalPage();
        return page != null ? page.isCount() : false;
    }

    public static <E, T> Page<E> ofPage(Page<T> page, Function<T, E> elementConvertor) {
        Page newPage = new Page(page.getPageNum(), page.getPageSize());
        newPage.setTotal(page.getTotal());
        newPage.setPages(page.getPages());
        newPage.setCount(page.isCount());
        newPage.setOrderBy(page.getOrderBy());
        PageHelperUtils.convertAddAll(page, elementConvertor, newPage);
        return newPage;
    }

    public static <E> Page<E> ofPageNoCountAdapt(Page<E> page) {
        PageHelperUtils.ofPageNoCountAdapt(page, 10000L);
        return page;
    }

    public static <E> Page<E> ofPageNoCountAdapt(Page<E> page, long maxTotal) {
        PageHelperUtils.noCountAdapt(page, page, maxTotal);
        return page;
    }

    public static <E, T> Page<E> ofPageNoCountAdapt(Page<T> page, Function<T, E> elementConvertor) {
        return PageHelperUtils.ofPageNoCountAdapt(page, elementConvertor, 10000L);
    }

    public static <E, T> Page<E> ofPageNoCountAdapt(Page<T> page, Function<T, E> elementConvertor, long maxTotal) {
        Page newPage = new Page(page.getPageNum(), page.getPageSize());
        PageHelperUtils.noCountAdapt(page, newPage, maxTotal);
        PageHelperUtils.convertAddAll(page, elementConvertor, newPage);
        return newPage;
    }

    private static void noCountAdapt(Page<?> page, Page<?> targetPage, long maxTotal) {
        if (page.isCount()) {
            targetPage.setTotal(page.getTotal());
            targetPage.setPages(page.getPages());
        } else if (page.getResult().size() < page.getPageSize()) {
            targetPage.setTotal((long)((page.getPages() - 1) * page.getPageSize() + page.getResult().size()));
            targetPage.setPages(page.getPageNum());
        } else {
            targetPage.setTotal(maxTotal);
            targetPage.setPages((int)(maxTotal / (long)page.getPageSize()));
        }
        targetPage.setCount(page.isCount());
        targetPage.setOrderBy(page.getOrderBy());
    }

    private static <E, T> void convertAddAll(Page<T> page, Function<T, E> elementConvertor, Page<E> targetPage) {
        if (!page.getResult().isEmpty()) {
            List list = page.getResult().stream().map(t -> elementConvertor.apply(t)).collect(Collectors.toList());
            targetPage.addAll(list);
        }
    }

    public static <E> NextQuerySupportPage<E> pageToNextQuerySupportPage(Page<E> page, Function<E, String> searchAfterSupplier) {
        NextQuerySupportArrayList<E> nextQuerySupportList = NextQuerySupportArrayList.newSupportSearchAfter(page, searchAfterSupplier);
        return new NextQuerySupportPage<E>(page.getPageNum(), page.getPageSize(), page.getTotal(), page.isCount(), page.getOrderBy(), nextQuerySupportList);
    }

    public static <T, E> NextQuerySupportPage<E> pageToNextQuerySupportPage(Page<T> page, Function<T, E> elementConvertor, Function<T, String> searchAfterSupplier) {
        NextQuerySupportArrayList<E> nextQuerySupportList = NextQuerySupportArrayList.newSupportSearchAfter(page, elementConvertor, searchAfterSupplier);
        return new NextQuerySupportPage<E>(page.getPageNum(), page.getPageSize(), page.getTotal(), page.isCount(), page.getOrderBy(), nextQuerySupportList);
    }

    public static <T, E> NextQuerySupportPage<E> ofNextQuerySupportPage(NextQuerySupportPage<T> page, Function<T, E> elementConvertor) {
        NextQuerySupportArrayList<E> nextQuerySupportList = NextQuerySupportArrayList.newSupportSearchAfter(page, elementConvertor, one -> page.getSearchAfter());
        return new NextQuerySupportPage<E>(page.getPageNum(), page.getPageSize(), page.getTotal(), page.isCount(), page.getOrderBy(), nextQuerySupportList);
    }

    public static <E> NextQuerySupportPage<E> ofNextQuerySupportPageNoCountAdapt(NextQuerySupportPage<E> page) {
        return PageHelperUtils.ofNextQuerySupportPageNoCountAdapt(page, 10000L);
    }

    public static <E> NextQuerySupportPage<E> ofNextQuerySupportPageNoCountAdapt(NextQuerySupportPage<E> page, long maxTotal) {
        PageHelperUtils.noCountAdapt(page, page, maxTotal);
        return page;
    }

    public static <E, T> NextQuerySupportPage<E> ofNextQuerySupportPageNoCountAdapt(NextQuerySupportPage<T> page, Function<T, E> elementConvertor) {
        return PageHelperUtils.ofNextQuerySupportPageNoCountAdapt(page, elementConvertor, 10000L);
    }

    public static <E, T> NextQuerySupportPage<E> ofNextQuerySupportPageNoCountAdapt(NextQuerySupportPage<T> page, Function<T, E> elementConvertor, long maxTotal) {
        NextQuerySupportPage<E> newPage = PageHelperUtils.ofNextQuerySupportPage(page, elementConvertor);
        PageHelperUtils.noCountAdapt(page, newPage, maxTotal);
        return newPage;
    }
}

