/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.client;

import com.theokanning.openai.DeleteResult;
import com.theokanning.openai.OpenAiResponse;
import com.theokanning.openai.assistants.assistant.Assistant;
import com.theokanning.openai.assistants.assistant.AssistantRequest;
import com.theokanning.openai.assistants.assistant.ModifyAssistantRequest;
import com.theokanning.openai.assistants.assistant.VectorStoreFileRequest;
import com.theokanning.openai.assistants.message.Message;
import com.theokanning.openai.assistants.message.MessageRequest;
import com.theokanning.openai.assistants.message.ModifyMessageRequest;
import com.theokanning.openai.assistants.run.CreateThreadAndRunRequest;
import com.theokanning.openai.assistants.run.ModifyRunRequest;
import com.theokanning.openai.assistants.run.Run;
import com.theokanning.openai.assistants.run.RunCreateRequest;
import com.theokanning.openai.assistants.run.SubmitToolOutputsRequest;
import com.theokanning.openai.assistants.run_step.RunStep;
import com.theokanning.openai.assistants.thread.Thread;
import com.theokanning.openai.assistants.thread.ThreadRequest;
import com.theokanning.openai.assistants.vector_store.ModifyVectorStoreRequest;
import com.theokanning.openai.assistants.vector_store.VectorStore;
import com.theokanning.openai.assistants.vector_store.VectorStoreRequest;
import com.theokanning.openai.assistants.vector_store_file.VectorStoreFile;
import com.theokanning.openai.assistants.vector_store_file_batch.VectorStoreFilesBatch;
import com.theokanning.openai.assistants.vector_store_file_batch.VectorStoreFilesBatchRequest;
import com.theokanning.openai.audio.CreateSpeechRequest;
import com.theokanning.openai.audio.TranscriptionResult;
import com.theokanning.openai.audio.TranslationResult;
import com.theokanning.openai.batch.Batch;
import com.theokanning.openai.batch.BatchRequest;
import com.theokanning.openai.billing.BillingUsage;
import com.theokanning.openai.billing.Subscription;
import com.theokanning.openai.completion.CompletionRequest;
import com.theokanning.openai.completion.CompletionResult;
import com.theokanning.openai.completion.chat.ChatCompletionRequest;
import com.theokanning.openai.completion.chat.ChatCompletionResult;
import com.theokanning.openai.embedding.EmbeddingRequest;
import com.theokanning.openai.embedding.EmbeddingResult;
import com.theokanning.openai.file.File;
import com.theokanning.openai.fine_tuning.FineTuningEvent;
import com.theokanning.openai.fine_tuning.FineTuningJob;
import com.theokanning.openai.fine_tuning.FineTuningJobCheckpoint;
import com.theokanning.openai.fine_tuning.FineTuningJobRequest;
import com.theokanning.openai.image.CreateImageRequest;
import com.theokanning.openai.image.ImageResult;
import com.theokanning.openai.model.Model;
import com.theokanning.openai.moderation.ModerationRequest;
import com.theokanning.openai.moderation.ModerationResult;
import io.reactivex.Single;
import java.time.LocalDate;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Streaming;

public interface OpenAiApi {
    @GET(value="models")
    public Single<OpenAiResponse<Model>> listModels();

    @GET(value="models/{model_id}")
    public Single<Model> getModel(@Path(value="model_id") String var1);

    @POST(value="completions")
    @Deprecated
    public Single<CompletionResult> createCompletion(@Body CompletionRequest var1);

    @Streaming
    @POST(value="completions")
    @Deprecated
    public Call<ResponseBody> createCompletionStream(@Body CompletionRequest var1);

    @POST(value="chat/completions")
    public Single<ChatCompletionResult> createChatCompletion(@Body ChatCompletionRequest var1);

    @Streaming
    @POST(value="chat/completions")
    public Call<ResponseBody> createChatCompletionStream(@Body ChatCompletionRequest var1);

    @POST(value="embeddings")
    public Single<EmbeddingResult> createEmbeddings(@Body EmbeddingRequest var1);

    @Multipart
    @POST(value="files")
    public Single<File> uploadFile(@Part(value="purpose") RequestBody var1, @Part MultipartBody.Part var2);

    @GET(value="files")
    public Single<OpenAiResponse<File>> listFiles();

    @DELETE(value="files/{file_id}")
    public Single<DeleteResult> deleteFile(@Path(value="file_id") String var1);

    @GET(value="files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @Streaming
    @GET(value="files/{file_id}/content")
    public Single<ResponseBody> retrieveFileContent(@Path(value="file_id") String var1);

    @POST(value="fine_tuning/jobs")
    public Single<FineTuningJob> createFineTuningJob(@Body FineTuningJobRequest var1);

    @GET(value="fine_tuning/jobs")
    public Single<OpenAiResponse<FineTuningJob>> listFineTuningJobs();

    @GET(value="fine_tuning/jobs/{fine_tuning_job_id}")
    public Single<FineTuningJob> retrieveFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @POST(value="fine_tuning/jobs/{fine_tuning_job_id}/cancel")
    public Single<FineTuningJob> cancelFineTuningJob(@Path(value="fine_tuning_job_id") String var1);

    @GET(value="fine_tuning/jobs/{fine_tuning_job_id}/events")
    public Single<OpenAiResponse<FineTuningEvent>> listFineTuningJobEvents(@Path(value="fine_tuning_job_id") String var1);

    @GET(value="fine_tuning/jobs/{fine_tuning_job_id}/checkpoints")
    public Single<OpenAiResponse<FineTuningJobCheckpoint>> listFineTuningCheckpoints(@Path(value="fine_tuning_job_id") String var1);

    @DELETE(value="models/{fine_tune_id}")
    public Single<DeleteResult> deleteFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="images/generations")
    public Single<ImageResult> createImage(@Body CreateImageRequest var1);

    @POST(value="images/edits")
    public Single<ImageResult> createImageEdit(@Body RequestBody var1);

    @POST(value="images/variations")
    public Single<ImageResult> createImageVariation(@Body RequestBody var1);

    @POST(value="audio/transcriptions")
    public Single<TranscriptionResult> createTranscription(@Body RequestBody var1);

    @POST(value="audio/translations")
    public Single<TranslationResult> createTranslation(@Body RequestBody var1);

    @POST(value="audio/speech")
    public Single<ResponseBody> createSpeech(@Body CreateSpeechRequest var1);

    @POST(value="moderations")
    public Single<ModerationResult> createModeration(@Body ModerationRequest var1);

    @Deprecated
    @GET(value="dashboard/billing/subscription")
    public Single<Subscription> subscription();

    @Deprecated
    @GET(value="dashboard/billing/usage")
    public Single<BillingUsage> billingUsage(@Query(value="start_date") LocalDate var1, @Query(value="end_date") LocalDate var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="assistants")
    public Single<Assistant> createAssistant(@Body AssistantRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="assistants")
    public Single<OpenAiResponse<Assistant>> listAssistants(@QueryMap Map<String, Object> var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="assistants/{assistant_id}")
    public Single<Assistant> retrieveAssistant(@Path(value="assistant_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="assistants/{assistant_id}")
    public Single<Assistant> modifyAssistant(@Path(value="assistant_id") String var1, @Body ModifyAssistantRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @DELETE(value="assistants/{assistant_id}")
    public Single<DeleteResult> deleteAssistant(@Path(value="assistant_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads")
    public Single<Thread> createThread(@Body ThreadRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}")
    public Single<Thread> retrieveThread(@Path(value="thread_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}")
    public Single<Thread> modifyThread(@Path(value="thread_id") String var1, @Body ThreadRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @DELETE(value="threads/{thread_id}")
    public Single<DeleteResult> deleteThread(@Path(value="thread_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/messages")
    public Single<Message> createMessage(@Path(value="thread_id") String var1, @Body MessageRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/messages")
    public Single<OpenAiResponse<Message>> listMessages(@Path(value="thread_id") String var1, @QueryMap Map<String, Object> var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/messages/{message_id}")
    public Single<Message> retrieveMessage(@Path(value="thread_id") String var1, @Path(value="message_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/messages/{message_id}")
    public Single<Message> modifyMessage(@Path(value="thread_id") String var1, @Path(value="message_id") String var2, @Body ModifyMessageRequest var3);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @DELETE(value="threads/{thread_id}/messages/{message_id}")
    public Single<DeleteResult> deleteMessage(@Path(value="thread_id") String var1, @Path(value="message_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs")
    public Single<Run> createRun(@Path(value="thread_id") String var1, @Body RunCreateRequest var2);

    @Streaming
    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs")
    public Call<ResponseBody> createRunStream(@Path(value="thread_id") String var1, @Body RunCreateRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/runs")
    public Single<Run> createThreadAndRun(@Body CreateThreadAndRunRequest var1);

    @Streaming
    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/runs")
    public Call<ResponseBody> createThreadAndRunStream(@Body CreateThreadAndRunRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/runs")
    public Single<OpenAiResponse<Run>> listRuns(@Path(value="thread_id") String var1, @QueryMap Map<String, String> var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/runs/{run_id}")
    public Single<Run> retrieveRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs/{run_id}")
    public Single<Run> modifyRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Body ModifyRunRequest var3);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs/{run_id}/submit_tool_outputs")
    public Single<Run> submitToolOutputs(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Body SubmitToolOutputsRequest var3);

    @Streaming
    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs/{run_id}/submit_tool_outputs")
    public Call<ResponseBody> submitToolOutputsStream(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Body SubmitToolOutputsRequest var3);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="threads/{thread_id}/runs/{run_id}/cancel")
    public Single<Run> cancelRun(@Path(value="thread_id") String var1, @Path(value="run_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/runs/{run_id}/steps")
    public Single<OpenAiResponse<RunStep>> listRunSteps(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @QueryMap Map<String, String> var3);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="threads/{thread_id}/runs/{run_id}/steps/{step_id}")
    public Single<RunStep> retrieveRunStep(@Path(value="thread_id") String var1, @Path(value="run_id") String var2, @Path(value="step_id") String var3);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="vector_stores")
    public Single<VectorStore> createVectorStore(@Body VectorStoreRequest var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores")
    public Single<OpenAiResponse<VectorStore>> listVectorStores(@QueryMap Map<String, Object> var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores/{vector_store_id}")
    public Single<VectorStore> retrieveVectorStore(@Path(value="vector_store_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="vector_stores/{vector_store_id}")
    public Single<VectorStore> modifyVectorStore(@Path(value="vector_store_id") String var1, @Body ModifyVectorStoreRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @DELETE(value="vector_stores/{vector_store_id}")
    public Single<DeleteResult> deleteVectorStore(@Path(value="vector_store_id") String var1);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="vector_stores/{vector_store_id}/files")
    public Single<VectorStoreFile> createVectorStoreFile(@Path(value="vector_store_id") String var1, @Body VectorStoreFileRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores/{vector_store_id}/files")
    public Single<OpenAiResponse<VectorStoreFile>> listVectorStoreFiles(@Path(value="vector_store_id") String var1, @QueryMap Map<String, Object> var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores/{vector_store_id}/files/{file_id}")
    public Single<VectorStoreFile> retrieveVectorStoreFile(@Path(value="vector_store_id") String var1, @Path(value="file_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @DELETE(value="vector_stores/{vector_store_id}/files/{file_id}")
    public Single<DeleteResult> deleteVectorStoreFile(@Path(value="vector_store_id") String var1, @Path(value="file_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="vector_stores/{vector_store_id}/file_batches")
    public Single<VectorStoreFilesBatch> createVectorStoreFileBatch(@Path(value="vector_store_id") String var1, @Body VectorStoreFilesBatchRequest var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores/{vector_store_id}/file_batches/{batch_id}")
    public Single<VectorStoreFilesBatch> retrieveVectorStoreFileBatch(@Path(value="vector_store_id") String var1, @Path(value="batch_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @POST(value="vector_stores/{vector_store_id}/file_batches/{batch_id}/cancel")
    public Single<VectorStoreFilesBatch> cancelVectorStoreFileBatch(@Path(value="vector_store_id") String var1, @Path(value="batch_id") String var2);

    @Headers(value={"OpenAI-Beta: assistants=v2"})
    @GET(value="vector_stores/{vector_store_id}/file_batches/{batch_id}/files")
    public Single<OpenAiResponse<VectorStoreFile>> listVectorStoreFilesInBatch(@Path(value="vector_store_id") String var1, @Path(value="batch_id") String var2, @QueryMap Map<String, Object> var3);

    @POST(value="batches")
    public Single<Batch> createBatch(@Body BatchRequest var1);

    @GET(value="batches/{batch_id}")
    public Single<Batch> retrieveBatch(@Path(value="batch_id") String var1);

    @POST(value="batches/{batch_id}/cancel")
    public Single<Batch> cancelBatch(@Path(value="batch_id") String var1);

    @GET(value="batches")
    public Single<OpenAiResponse<Batch>> listBatches(@QueryMap Map<String, Object> var1);
}

