/*
 * Decompiled with CFR 0.152.
 */
package com.theokanning.openai.service;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;

public class FileUtil {
    private static final Map<String, String> mimeMap = new HashMap<String, String>();

    public static MediaType getFileUploadMediaType(String fileName) {
        return MediaType.parse((String)mimeMap.getOrDefault(FileUtil.getFileExtension(fileName), "text/plain"));
    }

    public static String getFileExtension(String filename) {
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex >= 0 && dotIndex < filename.length() - 1) {
            return filename.substring(dotIndex);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readAllBytes(InputStream inputStream) {
        try (ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
            int nRead;
            byte[] data = new byte[2048];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from InputStream", e);
        }
    }

    static {
        mimeMap.put(".c", "text/x-c");
        mimeMap.put(".cs", "text/x-csharp");
        mimeMap.put(".cpp", "text/x-c++");
        mimeMap.put(".doc", "application/msword");
        mimeMap.put(".docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        mimeMap.put(".html", "text/html");
        mimeMap.put(".java", "text/x-java");
        mimeMap.put(".json", "application/json");
        mimeMap.put(".md", "text/markdown");
        mimeMap.put(".pdf", "application/pdf");
        mimeMap.put(".php", "text/x-php");
        mimeMap.put(".pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        mimeMap.put(".py", "text/x-python");
        mimeMap.put(".rb", "text/x-ruby");
        mimeMap.put(".tex", "text/x-tex");
        mimeMap.put(".txt", "text/plain");
        mimeMap.put(".css", "text/css");
        mimeMap.put(".js", "text/javascript");
        mimeMap.put(".sh", "application/x-sh");
        mimeMap.put(".ts", "application/typescript");
    }
}

