/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import io.github.microcks.util.JsonSchemaValidator;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPISchemaValidator {
    private static Logger log = LoggerFactory.getLogger(OpenAPISchemaValidator.class);
    private static final String[] STRUCTURES = new String[]{"allOf", "anyOf", "oneOf", "not", "items", "additionalProperties"};
    private static final String[] NOT_SUPPORTED_ATTRIBUTES = new String[]{"nullable", "discriminator", "readOnly", "writeOnly", "xml", "externalDocs", "example", "deprecated"};

    public static boolean isJsonValid(String schemaText, String jsonText) throws IOException {
        List<String> errors = OpenAPISchemaValidator.validateJson(schemaText, jsonText);
        if (!errors.isEmpty()) {
            log.debug("Get validation errors, returning false");
            return false;
        }
        return true;
    }

    public static List<String> validateJson(String schemaText, String jsonText) throws IOException {
        return OpenAPISchemaValidator.validateJson(OpenAPISchemaValidator.getJsonNodeForSchema(schemaText), JsonSchemaValidator.getJsonNode(jsonText));
    }

    public static List<String> validateJson(JsonNode schemaNode, JsonNode jsonNode) {
        schemaNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(schemaNode);
        try {
            return JsonSchemaValidator.validateJson(schemaNode, jsonNode);
        }
        catch (ProcessingException e) {
            log.debug("Got a ProcessingException while trying to interpret schemaNode as a real schema");
            ArrayList<String> errors = new ArrayList<String>();
            errors.add("schemaNode does not seem to represent a valid OpenAPI schema");
            return errors;
        }
    }

    public static JsonNode getJsonNode(String jsonText) throws IOException {
        return JsonSchemaValidator.getJsonNode(jsonText);
    }

    public static JsonNode getJsonNodeForSchema(String schemaText) throws IOException {
        boolean isYaml = true;
        String line = null;
        BufferedReader reader = new BufferedReader(new StringReader(schemaText));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                isYaml = false;
                break;
            }
            if (!line.startsWith("---")) continue;
            isYaml = true;
            break;
        }
        reader.close();
        ObjectMapper mapper = null;
        if (isYaml) {
            log.debug("Guessing OpenAPI spec format is YAML");
            mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        } else {
            log.debug("Guessing OpenAPI spec format is JSON");
            mapper = new ObjectMapper();
        }
        return mapper.readTree(schemaText);
    }

    private static JsonNode convertOpenAPISchemaToJsonSchema(JsonNode jsonNode) {
        for (String structure : STRUCTURES) {
            if (!jsonNode.has(structure) || !jsonNode.path(structure).isArray()) continue;
            jsonNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(jsonNode);
        }
        if (jsonNode.has("type") && jsonNode.path("type").asText().equals("object")) {
            OpenAPISchemaValidator.convertProperties(jsonNode.path("properties").elements());
        } else {
            OpenAPISchemaValidator.convertType(jsonNode);
        }
        for (String notSupported : NOT_SUPPORTED_ATTRIBUTES) {
            if (!jsonNode.has(notSupported)) continue;
            ((ObjectNode)jsonNode).remove(notSupported);
        }
        return jsonNode;
    }

    private static void convertProperties(Iterator<JsonNode> properties) {
        while (properties.hasNext()) {
            JsonNode property = properties.next();
            JsonNode jsonNode = OpenAPISchemaValidator.convertOpenAPISchemaToJsonSchema(property);
        }
    }

    private static void convertType(JsonNode node) {
        if (node.has("type") && !node.path("type").asText().equals("object")) {
            if (node.has("format") && node.path("format").asText().equals("date") && node.path("type").asText().equals("string")) {
                ((ObjectNode)node).put("format", "date-time");
            }
            if (node.path("nullable").asBoolean()) {
                String type = node.path("type").asText();
                ArrayNode typeArray = ((ObjectNode)node).putArray("type");
                typeArray.add(type).add("null");
            }
        }
    }
}

