/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.config;

import io.github.microcks.web.filter.CorsFilter;
import java.util.Arrays;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebConfiguration
implements ServletContextInitializer {
    private static Logger log = LoggerFactory.getLogger(WebConfiguration.class);
    @Autowired
    private Environment env;
    @Value(value="${mocks.rest.enable-cors-policy}")
    private final Boolean enableCorsPolicy = null;

    public void onStartup(ServletContext servletContext) throws ServletException {
        log.info("Starting web application configuration, using profiles: {}", (Object)Arrays.toString(this.env.getActiveProfiles()));
        EnumSet<DispatcherType> disps = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
        this.initCORSFilter(servletContext, disps);
        log.info("Web application fully configured");
    }

    @Bean
    public WebMvcConfigurer corsConfigurer() {
        return new WebMvcConfigurer(){

            public void addCorsMappings(CorsRegistry registry) {
                if (WebConfiguration.this.enableCorsPolicy.booleanValue()) {
                    registry.addMapping("/rest/**").allowedMethods(new String[]{"POST", "PUT", "GET", "OPTIONS", "DELETE", "PATCH"}).allowedOrigins(new String[]{"*"});
                }
            }
        };
    }

    private void initCORSFilter(ServletContext servletContext, EnumSet<DispatcherType> disps) {
        FilterRegistration.Dynamic corsFilter = servletContext.addFilter("corsFilter", (Filter)new CorsFilter());
        corsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/api/*"});
        corsFilter.addMappingForUrlPatterns(disps, true, new String[]{"/dynarest/*"});
        corsFilter.setAsyncSupported(true);
    }
}

