/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.repository;

import io.github.microcks.domain.DailyStatistic;
import io.github.microcks.repository.CustomDailyStatisticRepository;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;

public class DailyStatisticRepositoryImpl
implements CustomDailyStatisticRepository {
    private static Logger log = LoggerFactory.getLogger(DailyStatisticRepositoryImpl.class);
    @Autowired
    private MongoTemplate template;

    @Override
    public void incrementDailyStatistic(String day, String serviceName, String serviceVersion, String hourKey, String minuteKey) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"day").is((Object)day).and("serviceName").is((Object)serviceName).and("serviceVersion").is((Object)serviceVersion));
        Update update = new Update().inc("dailyCount", (Number)1).inc("hourlyCount." + hourKey, (Number)1).inc("minuteCount." + minuteKey, (Number)1);
        this.template.findAndModify(query, update, DailyStatistic.class);
    }

    @Override
    public DailyStatistic aggregateDailyStatistics(String day) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"day").is((Object)day));
        MapReduceResults results = this.template.mapReduce(query, "dailyStatistic", "classpath:mapDailyStatisticForADay.js", "classpath:reduceDailyStatisticForADay.js", WrappedDailyStatistic.class);
        if (log.isDebugEnabled()) {
            log.debug("aggregateDailyStatistics mapReduce for day " + day);
            log.debug("aggregateDailyStatistics mapReduce result counts: " + results.getCounts());
            for (WrappedDailyStatistic wdt : results) {
                log.debug("aggregateDailyStatistics mapReduce result value: " + wdt.getValue());
            }
        }
        if (results.getCounts().getOutputCount() > 0L) {
            return ((WrappedDailyStatistic)results.iterator().next()).getValue();
        }
        DailyStatistic statistic = new DailyStatistic();
        statistic.setDay(day);
        statistic.setDailyCount(0L);
        return statistic;
    }

    @Override
    public List<CustomDailyStatisticRepository.InvocationCount> aggregateDailyStatistics(String afterday, String beforeday) {
        Aggregation aggregation = Aggregation.newAggregation((AggregationOperation[])new AggregationOperation[]{Aggregation.match((Criteria)Criteria.where((String)"day").gte((Object)afterday).lte((Object)beforeday)), Aggregation.group((String[])new String[]{"day"}).sum("dailyCount").as("number"), Aggregation.project((String[])new String[]{"number"}).and("day").previousOperation(), Aggregation.sort((Sort.Direction)Sort.Direction.ASC, (String[])new String[]{"day"})});
        AggregationResults results = this.template.aggregate(aggregation, DailyStatistic.class, CustomDailyStatisticRepository.InvocationCount.class);
        return results.getMappedResults();
    }

    @Override
    public List<DailyStatistic> findTopStatistics(String day, int limit) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"day").is((Object)day)).with(Sort.by((Sort.Order[])new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "dailyCount")})).limit(limit);
        return this.template.find(query, DailyStatistic.class);
    }

    public class WrappedDailyStatistic {
        private String id;
        private DailyStatistic value;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public DailyStatistic getValue() {
            return this.value;
        }

        public void setValue(DailyStatistic value) {
            this.value = value;
        }
    }
}

