/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.asyncapi.AsyncAPIImporter;
import io.github.microcks.util.openapi.OpenAPIImporter;
import io.github.microcks.util.postman.PostmanCollectionImporter;
import io.github.microcks.util.soapui.SoapUIProjectImporter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRepositoryImporterFactory {
    private static Logger log = LoggerFactory.getLogger(MockRepositoryImporterFactory.class);

    public static MockRepositoryImporter getMockRepositoryImporter(File mockRepository) throws IOException {
        MockRepositoryImporter importer = null;
        String line = null;
        BufferedReader reader = Files.newBufferedReader(mockRepository.toPath(), Charset.forName("UTF-8"));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("\"_postman_id\":")) {
                log.info("Found a _postman_id in file so assuming it's a Postman Collection to import");
                importer = new PostmanCollectionImporter(mockRepository.getPath());
                break;
            }
            if (line.startsWith("<?xml")) {
                log.info("Found an XML pragma in file so assuming it's a SoapUI Project to import");
                importer = new SoapUIProjectImporter(mockRepository.getPath());
                break;
            }
            if (line.startsWith("openapi: 3") || line.startsWith("openapi: '3") || line.startsWith("openapi: \"3") || line.startsWith("\"openapi\": \"3") || line.startsWith("'openapi': '3")) {
                log.info("Found an openapi: 3 pragma in file so assuming it's an OpenAPI spec to import");
                importer = new OpenAPIImporter(mockRepository.getPath());
                break;
            }
            if (line.startsWith("asyncapi: 2") || line.startsWith("asyncapi: '2") || line.startsWith("asyncapi: \"2") || line.startsWith("\"asyncapi\": \"2") || line.startsWith("'asyncapi': '2")) {
                log.info("Found an asyncapi: 2 pragma in file so assuming it's an OpenAPI spec to import");
                importer = new AsyncAPIImporter(mockRepository.getPath());
                break;
            }
            if (!line.startsWith("\"swagger\":") && !line.startsWith("swagger:")) continue;
            log.warn("Swagger v2 format is not supported as it does not allow full examples specification, raising an exception");
            throw new IOException("Swagger v2 format is not supported as it does not allow full examples specification");
        }
        reader.close();
        if (importer == null) {
            log.info("Have not found any explicit marker so applying the default SoapUI Project importer...");
            importer = new SoapUIProjectImporter(mockRepository.getPath());
        }
        return importer;
    }
}

