/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.task;

import io.github.microcks.domain.ImportJob;
import io.github.microcks.domain.Secret;
import io.github.microcks.repository.ImportJobRepository;
import io.github.microcks.repository.SecretRepository;
import io.github.microcks.service.JobService;
import io.github.microcks.service.ServiceService;
import io.github.microcks.util.HTTPDownloader;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ImportServiceDefinitionTask {
    private static Logger log = LoggerFactory.getLogger(ImportServiceDefinitionTask.class);
    private static final int CHUNK_SIZE = 20;
    @Autowired
    private ServiceService serviceService;
    @Autowired
    private ImportJobRepository jobRepository;
    @Autowired
    private SecretRepository secretRepository;
    @Autowired
    private JobService jobService;
    @Value(value="${network.username}")
    private final String username;
    @Value(value="${network.password}")
    private final String password;

    public ImportServiceDefinitionTask() {
        this.username = null;
        this.password = null;
    }

    @Scheduled(cron="${services.update.interval}")
    public void importServiceDefinition() {
        int updated = 0;
        long startTime = System.currentTimeMillis();
        log.info("Starting scan of Service definitions update scheduled task...");
        long numJobs = this.jobRepository.count();
        log.debug("Found {} jobs to check. Splitting in {} chunks.", (Object)numJobs, (Object)(numJobs / 20L + 1L));
        int i = 0;
        while ((long)i < numJobs / 20L + 1L) {
            List jobs = this.jobRepository.findAll((Pageable)PageRequest.of((int)i, (int)20)).getContent();
            log.debug("Found {} jobs into chunk {}", (Object)jobs.size(), (Object)i);
            for (ImportJob job : jobs) {
                log.debug("Dealing with job " + job.getName());
                if (!job.isActive()) continue;
                Secret jobSecret = null;
                if (job.getSecretRef() != null) {
                    log.debug("Retrieving secret {} for job {}", (Object)job.getSecretRef().getName(), (Object)job.getName());
                    jobSecret = this.secretRepository.findById(job.getSecretRef().getSecretId()).orElse(null);
                }
                String etag = job.getEtag();
                String freshEtag = null;
                try {
                    freshEtag = HTTPDownloader.getURLEtag(job.getRepositoryUrl(), jobSecret, job.isRepositoryDisableSSLValidation());
                }
                catch (IOException ioe) {
                    log.error("Got an IOException while checking ETag for {}, pursuing...", (Object)job.getRepositoryUrl());
                }
                if (freshEtag != null && (freshEtag == null || freshEtag.equals(etag))) continue;
                log.debug("No Etag or fresher one found, updating service definition for " + job.getName());
                job.setEtag(freshEtag);
                this.jobService.doImportJob(job);
                ++updated;
            }
            ++i;
        }
        long duration = System.currentTimeMillis() - startTime;
        log.info("Task end in " + duration + " ms, updating " + updated + " job services definitions");
    }
}

