/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPIImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(AsyncAPIImporter.class);
    private boolean isYaml = true;
    private JsonNode spec;
    private String specContent;
    private ReferenceResolver referenceResolver;
    private static final List<String> VALID_VERBS = Arrays.asList("subscribe", "publish");

    public AsyncAPIImporter(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        this.referenceResolver = referenceResolver;
        try {
            String line = null;
            BufferedReader reader = Files.newBufferedReader(new File(specificationFilePath).toPath(), Charset.forName("UTF-8"));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("{") || line.startsWith("[")) {
                    this.isYaml = false;
                    break;
                }
                if (!line.startsWith("---") && !line.startsWith("asyncapi: ")) continue;
                this.isYaml = true;
                break;
            }
            reader.close();
            byte[] bytes = Files.readAllBytes(Paths.get(specificationFilePath, new String[0]));
            this.specContent = new String(bytes, Charset.forName("UTF-8"));
            ObjectMapper mapper = null;
            mapper = this.isYaml ? new ObjectMapper((JsonFactory)new YAMLFactory()) : new ObjectMapper();
            this.spec = mapper.readTree(bytes);
        }
        catch (Exception e) {
            log.error("Exception while parsing AsyncAPI specification file " + specificationFilePath, (Throwable)e);
            throw new IOException("AsyncAPI spec file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.spec.path("info").path("title").asText());
        service.setVersion(this.spec.path("info").path("version").asText());
        service.setType(ServiceType.EVENT);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = this.isYaml ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.ASYNC_API_SPEC);
        resource.setContent(this.specContent);
        results.add(resource);
        if (this.referenceResolver != null) {
            for (Operation operation : service.getOperations()) {
                JsonNode payloadNode;
                String[] operationElements = operation.getName().split(" ");
                String messageNamePtr = "/channels/" + operationElements[1].replaceAll("/", "~1");
                JsonNode messageNode = this.spec.at(messageNamePtr = messageNamePtr + "/" + operationElements[0].toLowerCase() + "/message");
                if (messageNode == null) continue;
                if (messageNode.has("$ref")) {
                    String ref = messageNode.path("$ref").asText();
                    messageNode = this.spec.at(ref.substring(1));
                }
                if (!messageNode.has("payload") || !(payloadNode = messageNode.path("payload")).has("$ref") || payloadNode.path("$ref").asText().startsWith("#")) continue;
                String ref = payloadNode.path("$ref").asText();
                if (ref.contains("#")) {
                    ref = ref.substring(0, ref.indexOf("#"));
                }
                try {
                    String content = this.referenceResolver.getHttpReferenceContent(ref, "UTF-8");
                    Resource schemaResource = new Resource();
                    schemaResource.setName(IdBuilder.buildResourceFullName((Service)service, (Operation)operation));
                    schemaResource.setPath(ref);
                    schemaResource.setContent(content);
                    String schemaFormat = "application/vnd.aai.asyncapi";
                    if (messageNode.has("schemaFormat")) {
                        schemaFormat = messageNode.path("schemaFormat").asText();
                    }
                    if (schemaFormat.startsWith("application/vnd.aai.asyncapi")) {
                        schemaResource.setType(ResourceType.ASYNC_API_SCHEMA);
                    } else if (schemaFormat.startsWith("application/vnd.oai.openapi")) {
                        schemaResource.setType(ResourceType.OPEN_API_SCHEMA);
                    } else if (schemaFormat.startsWith("application/schema+json") || schemaFormat.startsWith("application/schema+yaml")) {
                        schemaResource.setType(ResourceType.JSON_SCHEMA);
                    } else if (schemaFormat.startsWith("application/vnd.apache.avro")) {
                        schemaResource.setType(ResourceType.AVRO_SCHEMA);
                    }
                    results.add(schemaResource);
                }
                catch (IOException ioe) {
                    log.error("IOException while trying to resolve reference " + ref, (Throwable)ioe);
                    log.info("Ignoring the reference {} cause it could not be resolved", (Object)ref);
                }
            }
            this.referenceResolver.cleanResolvedReferences();
        }
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        String defaultContentType = "application/json";
        if (this.spec.has("defaultContentType")) {
            defaultContentType = this.spec.get("defaultContentType").asText("application/json");
        }
        Iterator channels = this.spec.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!operation.getName().equals(verbName.toUpperCase() + " " + channelName.trim())) continue;
                JsonNode messageBody = ((JsonNode)verb.getValue()).path("message");
                if (messageBody.has("$ref")) {
                    String ref = messageBody.path("$ref").asText();
                    messageBody = this.spec.at(ref.substring(1));
                }
                String contentType = defaultContentType;
                if (messageBody.has("contentType")) {
                    contentType = messageBody.path("contentType").asText();
                }
                if (!messageBody.has("examples")) continue;
                Iterator examples = messageBody.path("examples").elements();
                while (examples.hasNext()) {
                    JsonNode exampleNode = (JsonNode)examples.next();
                    Iterator exampleNames = exampleNode.fieldNames();
                    while (exampleNames.hasNext()) {
                        String exampleName = (String)exampleNames.next();
                        JsonNode example = exampleNode.path(exampleName);
                        if (!example.has("payload")) continue;
                        String exampleValue = this.getExamplePayload(example);
                        EventMessage eventMessage = new EventMessage();
                        eventMessage.setName(exampleName);
                        eventMessage.setContent(exampleValue);
                        eventMessage.setMediaType(contentType);
                        List<Header> headers = this.getExampleHeaders(example);
                        for (Header header : headers) {
                            eventMessage.addHeader(header);
                        }
                        result.add((Exchange)new UnidirectionalEvent(eventMessage));
                    }
                }
            }
        }
        return result;
    }

    private List<Operation> extractOperations() throws MockRepositoryImportException {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator channels = this.spec.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                JsonNode messageBody;
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!VALID_VERBS.contains(verbName)) continue;
                String operationName = verbName.toUpperCase() + " " + channelName.trim();
                Operation operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(verbName.toUpperCase());
                if (AsyncAPIImporter.channelHasParts(channelName)) {
                    operation.setDispatcher("URI_PARTS");
                } else {
                    operation.addResourcePath(channelName);
                }
                if (((JsonNode)verb.getValue()).has("bindings")) {
                    Iterator bindingNames = ((JsonNode)verb.getValue()).path("bindings").fieldNames();
                    while (bindingNames.hasNext()) {
                        String bindingName = (String)bindingNames.next();
                        JsonNode binding = ((JsonNode)verb.getValue()).path("bindings").path(bindingName);
                        switch (bindingName) {
                            case "kafka": {
                                break;
                            }
                            case "mqtt": {
                                Binding b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.MQTT);
                                if (binding.has("qos")) {
                                    b.setQoS(binding.path("qos").asText());
                                }
                                if (!binding.has("retain")) break;
                                b.setPersistent(binding.path("retain").asBoolean());
                                break;
                            }
                            case "amqp1": {
                                Binding b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.AMQP1);
                                if (binding.has("destinationName")) {
                                    b.setDestinationName(binding.path("destinationName").asText());
                                }
                                if (!binding.has("destinationType")) break;
                                b.setDestinationType(binding.path("destinationType").asText());
                            }
                        }
                    }
                }
                if ((messageBody = ((JsonNode)verb.getValue()).path("message")).has("bindings")) {
                    Iterator bindingNames = messageBody.path("bindings").fieldNames();
                    while (bindingNames.hasNext()) {
                        String bindingName = (String)bindingNames.next();
                        JsonNode binding = messageBody.path("bindings").path(bindingName);
                        switch (bindingName) {
                            case "kafka": {
                                Binding b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.KAFKA);
                                if (!binding.has("key")) break;
                                b.setKeyType(binding.path("key").path("type").asText());
                                break;
                            }
                        }
                    }
                }
                results.add(operation);
            }
        }
        return results;
    }

    private List<Header> getExampleHeaders(JsonNode example) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (example.has("headers")) {
            Iterator headers = null;
            if (example.path("headers").getNodeType() == JsonNodeType.OBJECT) {
                headers = example.path("headers").fields();
            } else if (example.path("headers").getNodeType() == JsonNodeType.STRING) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode headersNode = mapper.readTree(example.path("headers").asText());
                    headers = headersNode.fields();
                }
                catch (Exception e) {
                    log.warn("Headers value {} is a string but not JSON, skipping it", (Object)example.path("headers").asText());
                }
            }
            if (headers != null) {
                while (headers.hasNext()) {
                    Map.Entry property = (Map.Entry)headers.next();
                    String propertyName = (String)property.getKey();
                    Header header = new Header();
                    header.setName((String)property.getKey());
                    Set headerValues = Arrays.stream(((JsonNode)property.getValue()).asText().split(",")).map(value -> value.trim()).collect(Collectors.toSet());
                    header.setValues(headerValues);
                    results.add(header);
                }
            }
        }
        return results;
    }

    private String getExamplePayload(JsonNode example) {
        if (example.has("payload")) {
            if (example.path("payload").getNodeType() == JsonNodeType.ARRAY || example.path("payload").getNodeType() == JsonNodeType.OBJECT) {
                return example.path("payload").toString();
            }
            return example.path("payload").asText();
        }
        if (example.has("$payloadRef")) {
            String ref = example.path("$payloadRef").asText();
            JsonNode component = this.spec.at(ref.substring(1));
            return this.getExamplePayload(component);
        }
        return null;
    }

    private static boolean operationHasParameters(JsonNode operation) {
        if (!operation.has("parameters")) {
            return false;
        }
        Iterator parameters = operation.path("parameters").fields();
        if (parameters.hasNext()) {
            Map.Entry parameter = (Map.Entry)parameters.next();
            return true;
        }
        return false;
    }

    private static boolean channelHasParts(String channel) {
        return channel.indexOf("/:") != -1 || channel.indexOf("/{") != -1;
    }

    private static Binding retrieveOrInitOperationBinding(Operation operation, BindingType type) {
        Binding binding = null;
        if (operation.getBindings() != null) {
            binding = (Binding)operation.getBindings().get(type);
        }
        if (binding == null) {
            binding = new Binding(type);
            operation.addBinding(type.toString(), binding);
        }
        return binding;
    }
}

