/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web;

import io.github.microcks.service.ImportExportService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"})
public class ExportController {
    private static Logger log = LoggerFactory.getLogger(ExportController.class);
    @Autowired
    private ImportExportService importExportService;

    @RequestMapping(value={"/export"}, method={RequestMethod.GET})
    public ResponseEntity<?> exportRepository(@RequestParam(value="serviceIds") List<String> serviceIds) {
        log.debug("Extracting export for serviceIds {}", serviceIds);
        String json = this.importExportService.exportRepository(serviceIds, "json");
        byte[] body = json.getBytes();
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.setContentType(MediaType.APPLICATION_JSON);
        responseHeaders.set("Content-Disposition", "attachment; filename=microcks-repository.json");
        responseHeaders.setContentLength((long)body.length);
        return new ResponseEntity((Object)body, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }
}

