/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.grpc;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.grpc.MethodDescriptor;
import io.grpc.services.BinaryLogProvider;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Base64;

public class GrpcUtil {
    public static Descriptors.MethodDescriptor findMethodDescriptor(String base64ProtobufDescriptor, String serviceName, String methodName) throws UnsupportedEncodingException, InvalidProtocolBufferException, Descriptors.DescriptorValidationException {
        byte[] decodedBinaryPB = Base64.getDecoder().decode(base64ProtobufDescriptor.getBytes("UTF-8"));
        DescriptorProtos.FileDescriptorSet fds = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])decodedBinaryPB);
        Descriptors.ServiceDescriptor sd = null;
        if (fds.getFileCount() > 1) {
            ArrayList<Descriptors.FileDescriptor> dependencies = new ArrayList<Descriptors.FileDescriptor>();
            for (int i = 0; i < fds.getFileCount(); ++i) {
                Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fds.getFile(i), (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[dependencies.size()]), (boolean)true);
                dependencies.add(fd);
                sd = fd.findServiceByName(serviceName);
                if (sd == null) {
                    continue;
                }
                break;
            }
        } else {
            Descriptors.FileDescriptor fd = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fds.getFile(0), (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0], (boolean)true);
            sd = fd.findServiceByName(serviceName);
        }
        return sd.findMethodByName(methodName);
    }

    public static MethodDescriptor<byte[], byte[]> buildGenericUnaryMethodDescriptor(String fullMethodName) {
        return MethodDescriptor.newBuilder((MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER, (MethodDescriptor.Marshaller)BinaryLogProvider.BYTEARRAY_MARSHALLER).setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(fullMethodName).build();
    }
}

