/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui;

import com.eviware.soapui.config.DefintionPartConfig;
import com.eviware.soapui.config.MockResponseConfig;
import com.eviware.soapui.config.RESTMockActionConfig;
import com.eviware.soapui.config.RESTMockResponseConfig;
import com.eviware.soapui.config.RESTMockServiceConfig;
import com.eviware.soapui.config.WsdlInterfaceConfig;
import com.eviware.soapui.impl.rest.mock.RestMockResponse;
import com.eviware.soapui.impl.rest.mock.RestMockService;
import com.eviware.soapui.impl.rest.support.RestParamsPropertyHolder;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockService;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.QueryMatchMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.ScriptMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.mock.MockOperation;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.mock.MockService;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.support.types.StringToStringsMap;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.soapui.SoapUIXPathBuilder;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class SoapUIProjectImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(SoapUIProjectImporter.class);
    public static final String SERVICE_VERSION_PROPERTY = "version";
    private WsdlProject project;

    public SoapUIProjectImporter(String projectFilePath) throws IOException {
        try {
            this.project = new WsdlProject(projectFilePath);
        }
        catch (Exception e) {
            log.error("Exception while parsing SoapUI file " + projectFilePath, (Throwable)e);
            throw new IOException("SoapUI project file parsing error");
        }
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        result.addAll(this.getSoapServiceDefinitions(this.project.getMockServiceList()));
        result.addAll(this.getRestServiceDefinitions(this.project.getRestMockServiceList()));
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        WsdlMockService wsdlMockService = this.project.getMockServiceByName(service.getName());
        if (wsdlMockService != null) {
            WsdlInterface wi = this.project.getMockServiceByName(service.getName()).getMockedInterfaces()[0];
            String definitionName = ((WsdlInterfaceConfig)wi.getConfig()).getDefinition();
            List pis = this.project.getInterfaceList();
            for (Interface pi : pis) {
                List parts;
                WsdlInterface candidateWI;
                if (!(pi instanceof WsdlInterface) || !(candidateWI = (WsdlInterface)pi).getDefinition().equals(definitionName) || (parts = ((WsdlInterfaceConfig)candidateWI.getConfig()).getDefinitionCache().getPartList()) == null || parts.size() <= 0) continue;
                String wsdlContent = ((DefintionPartConfig)parts.get(0)).getContent().newCursor().getTextValue();
                for (int i = 1; i < parts.size(); ++i) {
                    DefintionPartConfig xsdConfig = (DefintionPartConfig)parts.get(i);
                    String xsdUrl = xsdConfig.getUrl();
                    String xsdName = xsdUrl.substring(xsdUrl.lastIndexOf(47) + 1);
                    String xsdContent = xsdConfig.getContent().newCursor().getTextValue();
                    Resource xsdResource = new Resource();
                    xsdResource.setName(xsdName);
                    xsdResource.setType(ResourceType.XSD);
                    xsdResource.setContent(xsdContent);
                    results.add(xsdResource);
                    wsdlContent = wsdlContent.replace(xsdUrl, "./" + xsdName);
                }
                Resource wsdlResource = new Resource();
                wsdlResource.setName(service.getName() + "-" + service.getVersion() + ".wsdl");
                wsdlResource.setType(ResourceType.WSDL);
                wsdlResource.setContent(wsdlContent);
                results.add(wsdlResource);
            }
        }
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        WsdlMockService mockService = this.project.getMockServiceByName(service.getName());
        if (mockService != null) {
            try {
                return this.getSoapMessageDefinitions((MockService)mockService, operation);
            }
            catch (XPathExpressionException xpe) {
                log.error("Got a XPathExpressionException while retrieving soap messages", (Throwable)xpe);
                throw new MockRepositoryImportException("XPathExpressionExceotion while retrieving soap messages", xpe);
            }
        }
        RestMockService restMockService = this.project.getRestMockServiceByName(service.getName());
        if (restMockService != null) {
            return this.getRestMessageDefinitions(restMockService, operation);
        }
        return new ArrayList<Exchange>();
    }

    private List<Service> getSoapServiceDefinitions(List<WsdlMockService> mockServices) throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        for (WsdlMockService wms : mockServices) {
            Service service = new Service();
            service.setName(wms.getName());
            service.setType(ServiceType.SOAP_HTTP);
            WsdlInterface[] wi = wms.getMockedInterfaces();
            if (wi == null || wi.length > 1) {
                // empty if block
            }
            service.setXmlNS(wi[0].getBindingName().getNamespaceURI());
            String version = wms.getPropertyValue(SERVICE_VERSION_PROPERTY);
            if (version == null) {
                log.error("Version property is missing in Project properties");
                throw new MockRepositoryImportException("Version property is missing in Project properties");
            }
            service.setVersion(version);
            service.setOperations(this.extractOperations((MockService)wms, wi[0]));
            result.add(service);
        }
        return result;
    }

    private List<Service> getRestServiceDefinitions(List<RestMockService> mockServices) {
        ArrayList<Service> result = new ArrayList<Service>();
        for (RestMockService rms : mockServices) {
            Service service = new Service();
            service.setName(rms.getName());
            service.setType(ServiceType.REST);
            String version = rms.getPropertyValue(SERVICE_VERSION_PROPERTY);
            if (version == null) {
                // empty if block
            }
            service.setVersion(version);
            service.setOperations(this.extractOperations(rms));
            result.add(service);
        }
        return result;
    }

    private List<Operation> extractOperations(MockService mockService, WsdlInterface wi) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        List operations = mockService.getMockOperationList();
        for (MockOperation mockOperation : operations) {
            Operation operation = new Operation();
            operation.setName(mockOperation.getName());
            WsdlOperation wo = wi.getOperationByName(mockOperation.getName());
            operation.setAction(wo.getAction());
            operation.setInputName(wo.getInputName());
            operation.setOutputName(wo.getOutputName());
            WsdlMockOperation wmo = (WsdlMockOperation)mockOperation;
            operation.setDispatcher(wmo.getDispatchStyle());
            MockOperationDispatcher dispatcher = wmo.getDispatcher();
            if (dispatcher instanceof QueryMatchMockOperationDispatcher) {
                QueryMatchMockOperationDispatcher qmDispatcher = (QueryMatchMockOperationDispatcher)dispatcher;
                String query = qmDispatcher.getQueryAt(0).getQuery();
                operation.setDispatcherRules(query);
            } else if (dispatcher instanceof ScriptMockOperationDispatcher) {
                ScriptMockOperationDispatcher sDispatcher = (ScriptMockOperationDispatcher)dispatcher;
                String script = sDispatcher.getMockOperation().getScript();
                operation.setDispatcherRules(script);
            }
            result.add(operation);
        }
        return result;
    }

    private List<Operation> extractOperations(RestMockService mockService) {
        HashMap<String, Operation> collectedOperations = new HashMap<String, Operation>();
        List actions = ((RESTMockServiceConfig)mockService.getConfig()).getRestMockActionList();
        for (RESTMockActionConfig action : actions) {
            Operation operation = (Operation)collectedOperations.get(action.getName());
            if (operation == null) {
                operation = new Operation();
                operation.setName(action.getName());
                operation.setMethod(action.getMethod());
                operation.setDispatcher(action.getDispatchStyle().toString());
                if ("SEQUENCE".equals(action.getDispatchStyle().toString())) {
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(operation.getName()));
                } else if ("SCRIPT".equals(action.getDispatchStyle().toString())) {
                    String script = action.getDispatchPath();
                    operation.setDispatcherRules(script);
                }
            }
            operation.addResourcePath(action.getResourcePath());
            collectedOperations.put(action.getName(), operation);
        }
        return new ArrayList<Operation>(collectedOperations.values());
    }

    private List<Exchange> getSoapMessageDefinitions(MockService mockService, Operation operation) throws XPathExpressionException {
        HashMap<Request, Response> result;
        block9: {
            ArrayList<Object> requests;
            MockOperation mockOperation;
            block8: {
                result = new HashMap<Request, Response>();
                mockOperation = mockService.getMockOperationByName(operation.getName());
                Map<String, WsdlTestRequest> availableRequests = this.collectWsdlTestRequests(operation);
                requests = new ArrayList<Object>();
                for (MockResponse mockResponse : mockOperation.getMockResponses()) {
                    Object matchingRequest = availableRequests.get(mockResponse.getName());
                    if (matchingRequest == null) {
                        matchingRequest = availableRequests.get(mockResponse.getName() + " Request");
                    }
                    if (matchingRequest == null && mockResponse.getName().contains("Response")) {
                        matchingRequest = availableRequests.get(mockResponse.getName().replace("Response", "Request"));
                    }
                    if (matchingRequest == null) {
                        log.warn("No request found for response " + mockResponse.getName() + " into SoapUI project " + this.project.getName());
                        continue;
                    }
                    requests.add(matchingRequest);
                }
                if (!"QUERY_MATCH".equals(operation.getDispatcher())) break block8;
                XPathExpression xpath = this.initializeXPathMatcher(operation);
                Map<String, String> map = this.buildQueryMatchDispatchCriteriaToResponseMap((WsdlMockOperation)mockOperation);
                for (WsdlTestRequest wsdlTestRequest : requests) {
                    String dispatchCriteria = xpath.evaluate(new InputSource(new StringReader(wsdlTestRequest.getRequestContent())));
                    String correspondingResponse = map.get(dispatchCriteria);
                    MockResponse mockResponse = mockOperation.getMockResponseByName(correspondingResponse);
                    if (mockResponse == null) continue;
                    Response response = this.buildResponse(mockResponse, dispatchCriteria);
                    Request request = this.buildRequest(wsdlTestRequest);
                    result.put(request, response);
                }
                break block9;
            }
            if (!"SCRIPT".equals(operation.getDispatcher())) break block9;
            for (WsdlTestRequest wsdlTestRequest : requests) {
                MockResponse mockResponse = mockOperation.getMockResponseByName(wsdlTestRequest.getName().replace(" Request", ""));
                if (mockResponse == null && wsdlTestRequest.getName().contains("Request")) {
                    mockResponse = mockOperation.getMockResponseByName(wsdlTestRequest.getName().replace(" Request", " Response"));
                }
                if (mockResponse == null) {
                    log.warn("No response found for request " + wsdlTestRequest.getName() + " into SoapUI project " + this.project.getName());
                    continue;
                }
                Response response = this.buildResponse(mockResponse, mockResponse.getName());
                Request request = this.buildRequest(wsdlTestRequest);
                result.put(request, response);
            }
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private List<Exchange> getRestMessageDefinitions(RestMockService mockService, Operation operation) {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        ArrayList mockResponses = new ArrayList();
        for (Object mockOperation : mockService.getMockOperationList()) {
            if (!mockOperation.getName().equals(operation.getName())) continue;
            mockResponses.addAll(mockOperation.getMockResponses());
        }
        HashMap<String, RESTMockActionConfig> mockRestActionConfigsForResponses = new HashMap<String, RESTMockActionConfig>();
        for (RESTMockActionConfig mockActionConfig : ((RESTMockServiceConfig)mockService.getConfig()).getRestMockActionList()) {
            if (!mockActionConfig.getName().equals(operation.getName())) continue;
            for (RESTMockResponseConfig rESTMockResponseConfig : mockActionConfig.getResponseList()) {
                mockRestActionConfigsForResponses.put(rESTMockResponseConfig.getName(), mockActionConfig);
            }
        }
        Map<String, RestTestRequest> availableRequests = this.collectRestTestRequests(operation);
        HashMap<RestTestRequest, MockResponse> requestToResponse = new HashMap<RestTestRequest, MockResponse>();
        for (MockResponse mockResponse : mockResponses) {
            RestTestRequest matchingRequest = availableRequests.get(mockResponse.getName());
            if (matchingRequest == null) {
                matchingRequest = availableRequests.get(mockResponse.getName() + " Request");
            }
            if (matchingRequest == null && mockResponse.getName().contains("Response")) {
                matchingRequest = availableRequests.get(mockResponse.getName().replace("Response", "Request"));
            }
            if (matchingRequest == null) {
                log.warn("No request found for response " + mockResponse.getName() + " into SoapUI project " + this.project.getName());
                continue;
            }
            requestToResponse.put(matchingRequest, mockResponse);
        }
        for (Map.Entry entry2 : requestToResponse.entrySet()) {
            RestTestRequest rtr = (RestTestRequest)entry2.getKey();
            MockResponse mr = (MockResponse)entry2.getValue();
            String dispatchCriteria = null;
            if ("SEQUENCE".equals(operation.getDispatcher())) {
                RESTMockActionConfig actionConfig = (RESTMockActionConfig)mockRestActionConfigsForResponses.get(mr.getName());
                dispatchCriteria = DispatchCriteriaHelper.extractFromURIPattern(operation.getDispatcherRules(), operation.getName(), actionConfig.getResourcePath());
            } else if ("SCRIPT".equals(operation.getDispatcher())) {
                dispatchCriteria = mr.getName();
            }
            Response response = this.buildResponse((RestMockResponse)mr, dispatchCriteria);
            Request request = this.buildRequest(rtr);
            result.put(request, response);
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private Map<String, WsdlTestRequest> collectWsdlTestRequests(Operation operation) {
        HashMap<String, WsdlTestRequest> result = new HashMap<String, WsdlTestRequest>();
        for (TestSuite testsuite : this.project.getTestSuiteList()) {
            for (TestCase testcase : testsuite.getTestCaseList()) {
                for (TestStep teststep : testcase.getTestStepList()) {
                    WsdlTestRequestStep ws;
                    WsdlTestRequest wr;
                    if (!(teststep instanceof WsdlTestRequestStep) || !(wr = (ws = (WsdlTestRequestStep)teststep).getHttpRequest()).getOperationName().equals(operation.getName())) continue;
                    result.put(wr.getName(), wr);
                }
            }
        }
        return result;
    }

    private Map<String, RestTestRequest> collectRestTestRequests(Operation operation) {
        HashMap<String, RestTestRequest> result = new HashMap<String, RestTestRequest>();
        for (TestSuite testsuite : this.project.getTestSuiteList()) {
            for (TestCase testcase : testsuite.getTestCaseList()) {
                for (TestStep teststep : testcase.getTestStepList()) {
                    if (!(teststep instanceof RestTestRequestStep)) continue;
                    RestTestRequestStep rs = (RestTestRequestStep)teststep;
                    RestTestRequest rr = rs.getTestRequest();
                    if (!rs.getResourcePath().equals(operation.getName())) continue;
                    result.put(rr.getName(), rr);
                }
            }
        }
        return result;
    }

    private XPathExpression initializeXPathMatcher(Operation operation) throws XPathExpressionException {
        return SoapUIXPathBuilder.buildXPathMatcherFromRules(operation.getDispatcherRules());
    }

    private Map<String, String> buildQueryMatchDispatchCriteriaToResponseMap(WsdlMockOperation wmo) {
        HashMap<String, String> matchResponseMap = new HashMap<String, String>();
        MockOperationDispatcher dispatcher = wmo.getDispatcher();
        if (dispatcher instanceof QueryMatchMockOperationDispatcher) {
            QueryMatchMockOperationDispatcher qmDispatcher = (QueryMatchMockOperationDispatcher)dispatcher;
            for (int i = 0; i < qmDispatcher.getQueryCount(); ++i) {
                QueryMatchMockOperationDispatcher.Query query = qmDispatcher.getQueryAt(i);
                matchResponseMap.put(query.getMatch(), query.getResponse());
            }
        }
        return matchResponseMap;
    }

    private Response buildResponse(MockResponse mockResponse, String dispatchCriteria) {
        Response response = new Response();
        response.setName(mockResponse.getName());
        response.setContent(((WsdlMockResponse)mockResponse).getResponseContent());
        response.setHeaders(this.buildHeaders(((WsdlMockResponse)mockResponse).getResponseHeaders()));
        response.setDispatchCriteria(dispatchCriteria);
        if ("500".equals(((MockResponseConfig)((WsdlMockResponse)mockResponse).getConfig()).getHttpResponseStatus())) {
            response.setFault(true);
        }
        return response;
    }

    private Response buildResponse(RestMockResponse mockResponse, String dispatchCriteria) {
        Response response = new Response();
        response.setName(mockResponse.getName());
        response.setContent(mockResponse.getResponseContent());
        response.setHeaders(this.buildHeaders(mockResponse.getResponseHeaders()));
        response.setStatus(String.valueOf(mockResponse.getResponseHttpStatus()));
        response.setMediaType(mockResponse.getMediaType());
        response.setDispatchCriteria(dispatchCriteria);
        return response;
    }

    private Request buildRequest(WsdlTestRequest wtr) {
        Request request = new Request();
        request.setName(wtr.getName());
        request.setContent(wtr.getRequestContent());
        request.setHeaders(this.buildHeaders(wtr.getRequestHeaders()));
        return request;
    }

    private Request buildRequest(RestTestRequest rtr) {
        Request request = new Request();
        request.setName(rtr.getName());
        request.setContent(rtr.getRequestContent());
        request.setHeaders(this.buildHeaders(rtr.getRequestHeaders()));
        RestParamsPropertyHolder paramsHolder = rtr.getParams();
        for (int i = 0; i < paramsHolder.getPropertyCount(); ++i) {
            Parameter param = new Parameter();
            param.setName(paramsHolder.getPropertyAt(i).getName());
            param.setValue(paramsHolder.getPropertyAt(i).getValue());
            request.addQueryParameter(param);
        }
        return request;
    }

    private Set<Header> buildHeaders(StringToStringsMap requestHeaders) {
        if (requestHeaders == null || requestHeaders.size() == 0) {
            return null;
        }
        HashSet<Header> headers = new HashSet<Header>();
        for (Map.Entry entry : requestHeaders.entrySet()) {
            Header header = new Header();
            header.setName((String)entry.getKey());
            header.setValues(new HashSet((Collection)entry.getValue()));
            headers.add(header);
        }
        return headers;
    }
}

