/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DispatchCriteriaHelper {
    public static String extractParamsFromURI(String uri) {
        if (uri.contains("?") && uri.contains("=")) {
            String parameters = uri.substring(uri.indexOf("?") + 1);
            StringBuilder params = new StringBuilder();
            for (String parameter : parameters.split("&")) {
                String[] pair = parameter.split("=");
                try {
                    String key = URLDecoder.decode(pair[0], "UTF-8");
                    String value = URLDecoder.decode(pair[1], "UTF-8");
                    if (params.length() > 0) {
                        params.append(" && ");
                    }
                    params.append(key);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            return params.toString();
        }
        return "";
    }

    public static String extractCommonPrefix(List<String> uris) {
        String commonURIPath = uris.get(0);
        for (int prefixLen = 0; prefixLen < uris.get(0).length(); ++prefixLen) {
            char c = uris.get(0).charAt(prefixLen);
            for (int i = 1; i < uris.size(); ++i) {
                if (prefixLen < uris.get(i).length() && uris.get(i).charAt(prefixLen) == c) continue;
                String commonString = uris.get(i).substring(0, prefixLen);
                return commonString.substring(0, commonString.lastIndexOf(47));
            }
        }
        return commonURIPath;
    }

    public static String extractCommonSuffix(List<String> uris) {
        for (int suffixLen = 0; suffixLen < uris.get(0).length(); ++suffixLen) {
            char c = uris.get(0).charAt(uris.get(0).length() - suffixLen - 1);
            for (int i = 1; i < uris.size(); ++i) {
                if (suffixLen < uris.get(i).length() && uris.get(i).charAt(uris.get(i).length() - suffixLen - 1) == c) continue;
                if (suffixLen > 0) {
                    String commonString = uris.get(i).substring(uris.get(i).length() - suffixLen - 1);
                    return commonString.substring(commonString.indexOf(47));
                }
                return null;
            }
        }
        return null;
    }

    public static String extractPartsFromURIs(List<String> uris) {
        String commonURIPath = DispatchCriteriaHelper.extractCommonPrefix(uris);
        String commonURIEnd = DispatchCriteriaHelper.extractCommonSuffix(uris);
        int partsLen = 0;
        for (String uri : uris) {
            int numOfParts;
            String parts = uri.substring(commonURIPath.length() + 1);
            if (commonURIEnd != null) {
                parts = parts.substring(0, parts.lastIndexOf(commonURIEnd));
            }
            if ((numOfParts = parts.split("/").length) <= partsLen) continue;
            partsLen = numOfParts;
        }
        if (partsLen > 0) {
            StringBuilder parts = new StringBuilder();
            for (int i = 0; i < partsLen; ++i) {
                parts.append("part").append(i + 1);
                if (i >= partsLen - 1) continue;
                parts.append(" && ");
            }
            return parts.toString();
        }
        return "";
    }

    public static String extractPartsFromURIPattern(String pattern) {
        Pattern partsP;
        Matcher partsM;
        if (pattern.contains("?")) {
            pattern = pattern.substring(0, pattern.indexOf(63));
        }
        if (pattern.contains("{{") && pattern.contains("}}")) {
            pattern = pattern.replaceAll("\\{\\{", "");
            pattern = pattern.replaceAll("\\}\\}", "");
        }
        if (pattern.contains("$")) {
            pattern = pattern.replaceAll("\\$", "");
        }
        String partsPattern = null;
        if (pattern.contains("/{")) {
            partsPattern = pattern.replaceAll("(\\{[^\\}]+\\})", "\\\\{(.+)\\\\}");
        } else if (pattern.contains("/:")) {
            partsPattern = pattern.replaceAll("(/:[^:^/]+)", "\\/:(.+)");
        }
        if (partsPattern != null && (partsM = (partsP = Pattern.compile(partsPattern)).matcher(pattern)).matches()) {
            StringBuilder parts = new StringBuilder();
            for (int i = 1; i < partsM.groupCount() + 1; ++i) {
                parts.append(partsM.group(i));
                if (i >= partsM.groupCount()) continue;
                parts.append(" && ");
            }
            return parts.toString();
        }
        return "";
    }

    public static String extractFromURIPattern(String paramsRuleString, String pattern, String realURI) {
        TreeMap<String, String> criteriaMap = new TreeMap<String, String>();
        String partsPattern = null;
        String valuesPattern = null;
        if (pattern.indexOf("/{") != -1) {
            partsPattern = pattern.replaceAll("(\\{[^\\}]+\\})", "\\\\{(.+)\\\\}");
            valuesPattern = pattern.replaceAll("(\\{[^\\}]+\\})", "(.+)");
        } else {
            partsPattern = pattern.replaceAll("(:[^:^/]+)", "\\:(.+)");
            valuesPattern = pattern.replaceAll("(:[^:^/]+)", "(.+)");
        }
        if (pattern.contains("$")) {
            partsPattern = partsPattern.replaceAll("\\$", "\\\\\\$");
            valuesPattern = valuesPattern.replaceAll("\\$", "\\\\\\$");
        }
        Pattern partsP = Pattern.compile(partsPattern);
        Matcher partsM = partsP.matcher(pattern);
        Pattern valuesP = Pattern.compile(valuesPattern);
        Matcher valuesM = valuesP.matcher(realURI);
        Set paramsRule = Arrays.stream(paramsRuleString.split("&&")).map(String::trim).distinct().collect(Collectors.toUnmodifiableSet());
        if (valuesM.matches() && partsM.matches() && valuesM.groupCount() == partsM.groupCount()) {
            for (int i = 1; i < partsM.groupCount() + 1; ++i) {
                String paramName = partsM.group(i);
                String paramValue = valuesM.group(i);
                if (!paramsRule.contains(paramName)) continue;
                criteriaMap.put(paramName, paramValue);
            }
        }
        StringBuilder result = new StringBuilder();
        for (String criteria : criteriaMap.keySet()) {
            result.append("/").append(criteria).append("=").append((String)criteriaMap.get(criteria));
        }
        return result.toString();
    }

    public static String buildFromPartsMap(Map<String, String> partsMap) {
        if (partsMap != null && !partsMap.isEmpty()) {
            TreeMap<String, String> criteriaMap = new TreeMap<String, String>();
            criteriaMap.putAll(partsMap);
            StringBuilder result = new StringBuilder();
            for (String criteria : criteriaMap.keySet()) {
                result.append("/").append(criteria).append("=").append((String)criteriaMap.get(criteria));
            }
            return result.toString();
        }
        return "";
    }

    public static String buildFromParamsMap(String paramsRule, Map<String, String> paramsMap) {
        if (paramsMap != null && !paramsMap.isEmpty()) {
            TreeMap<String, String> criteriaMap = new TreeMap<String, String>();
            criteriaMap.putAll(paramsMap);
            StringBuilder result = new StringBuilder();
            for (String criteria : criteriaMap.keySet()) {
                if (!paramsRule.contains(criteria)) continue;
                result.append("?").append(criteria).append("=").append((String)criteriaMap.get(criteria));
            }
            return result.toString();
        }
        return "";
    }

    public static String extractFromURIParams(String paramsRule, String uri) {
        TreeMap<String, String> criteriaMap = new TreeMap<String, String>();
        if (uri.contains("?") && uri.contains("=")) {
            String parameters = uri.substring(uri.indexOf("?") + 1);
            for (String parameter : parameters.split("&")) {
                String[] pair = parameter.split("=");
                try {
                    String key = URLDecoder.decode(pair[0], "UTF-8");
                    String value = URLDecoder.decode(pair[1], "UTF-8");
                    criteriaMap.put(key, value);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            StringBuilder result = new StringBuilder();
            for (String criteria : criteriaMap.keySet()) {
                if (!paramsRule.contains(criteria)) continue;
                result.append("?").append(criteria).append("=").append((String)criteriaMap.get(criteria));
            }
            return result.toString();
        }
        return "";
    }

    public static String extractFromParamMap(String paramsRule, Map<String, String> paramMap) {
        Set sortedKeys = paramMap.keySet().stream().sorted().collect(Collectors.toSet());
        StringBuilder result = new StringBuilder();
        for (String param : sortedKeys) {
            if (!paramsRule.contains(param)) continue;
            result.append("?").append(param).append("=").append(paramMap.get(param));
        }
        return result.toString();
    }
}

