/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import io.github.microcks.domain.ParameterConstraint;
import io.github.microcks.domain.ParameterLocation;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class ParameterConstraintUtil {
    public static String validateConstraint(HttpServletRequest request, ParameterConstraint constraint) {
        String value = null;
        if (ParameterLocation.header == constraint.getIn()) {
            value = request.getHeader(constraint.getName());
        } else if (ParameterLocation.query == constraint.getIn()) {
            value = request.getParameter(constraint.getName());
        }
        if (value != null) {
            if (constraint.getMustMatchRegexp() != null && !Pattern.matches(constraint.getMustMatchRegexp(), value)) {
                return "Parameter " + constraint.getName() + " should match " + constraint.getMustMatchRegexp();
            }
        } else if (constraint.isRequired()) {
            return "Parameter " + constraint.getName() + " is required";
        }
        return null;
    }
}

