/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.soapui.assertions;

import io.github.microcks.util.soapui.assertions.JsonPathContentAssertion;
import io.github.microcks.util.soapui.assertions.NotSoapFaultAssertion;
import io.github.microcks.util.soapui.assertions.SLAAssertion;
import io.github.microcks.util.soapui.assertions.SchemaConformanceAssertion;
import io.github.microcks.util.soapui.assertions.SimpleContainsAssertion;
import io.github.microcks.util.soapui.assertions.SimpleNotContainsAssertion;
import io.github.microcks.util.soapui.assertions.SoapFaultAssertion;
import io.github.microcks.util.soapui.assertions.SoapResponseAssertion;
import io.github.microcks.util.soapui.assertions.SoapUIAssertion;
import io.github.microcks.util.soapui.assertions.UnknownAssertion;
import io.github.microcks.util.soapui.assertions.ValidHttpCodesAssertion;
import io.github.microcks.util.soapui.assertions.XPathContainsAssertion;
import java.util.Map;

public class AssertionFactory {
    public static final String RESPONSE_SLA_ASSERTION = "Response SLA Assertion";
    public static final String VALID_HTTP_STATUS_CODES = "Valid HTTP Status Codes";
    public static final String SOAP_FAULT_ASSERTION = "Not SOAP Fault Assertion";
    public static final String NOT_SOAP_FAULT_ASSERTION = "SOAP Fault Assertion";
    public static final String SOAP_RESPONSE = "SOAP Response";
    public static final String SCHEMA_COMPLIANCE = "Schema Compliance";
    public static final String XPATH_CONTAINS = "XPath Match";
    public static final String JSONPATH_MATCH = "JsonPath Match";
    public static final String SIMPLE_CONTAINS = "Simple Contains";
    public static final String SIMPLE_NOT_CONTAINS = "Simple NotContains";

    private AssertionFactory() {
    }

    public static SoapUIAssertion intializeAssertion(String type, Map<String, String> configParams) {
        SoapUIAssertion assertion = null;
        switch (type) {
            case "Response SLA Assertion": {
                assertion = new SLAAssertion();
                break;
            }
            case "Valid HTTP Status Codes": {
                assertion = new ValidHttpCodesAssertion();
                break;
            }
            case "Not SOAP Fault Assertion": {
                assertion = new SoapFaultAssertion();
                break;
            }
            case "SOAP Fault Assertion": {
                assertion = new NotSoapFaultAssertion();
                break;
            }
            case "SOAP Response": {
                assertion = new SoapResponseAssertion();
                break;
            }
            case "Schema Compliance": {
                assertion = new SchemaConformanceAssertion();
                break;
            }
            case "XPath Match": {
                assertion = new XPathContainsAssertion();
                break;
            }
            case "JsonPath Match": {
                assertion = new JsonPathContentAssertion();
                break;
            }
            case "Simple Contains": {
                assertion = new SimpleContainsAssertion();
                break;
            }
            case "Simple NotContains": {
                assertion = new SimpleNotContainsAssertion();
                break;
            }
            default: {
                assertion = new UnknownAssertion(type);
            }
        }
        assertion.configure(configParams);
        return assertion;
    }
}

