/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.listener;

import io.github.microcks.event.ServiceViewChangeEvent;
import io.github.microcks.listener.ServiceChangeEventChannel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"async-api.enabled"}, havingValue="true", matchIfMissing=true)
public class KafkaServiceChangeEventChannel
implements ServiceChangeEventChannel {
    @Autowired
    private KafkaTemplate<String, ServiceViewChangeEvent> kafkaTemplate;

    @Override
    public void sendServiceViewChangeEvent(ServiceViewChangeEvent event) throws Exception {
        this.kafkaTemplate.send("microcks-services-updates", (Object)event.getServiceId(), (Object)event);
    }
}

