/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.asyncapi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import io.github.microcks.domain.Binding;
import io.github.microcks.domain.BindingType;
import io.github.microcks.domain.EventMessage;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.domain.UnidirectionalEvent;
import io.github.microcks.util.AbstractJsonRepositoryImporter;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.IdBuilder;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.metadata.MetadataExtractor;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncAPIImporter
extends AbstractJsonRepositoryImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(AsyncAPIImporter.class);
    private static final String[] MULTI_STRUCTURES = new String[]{"allOf", "anyOf", "oneOf"};
    private static final List<String> VALID_VERBS = Arrays.asList("subscribe", "publish");
    private static final String BINDINGS = "bindings";
    private static final String SCHEMA_NODE = "schema";
    private static final String EXAMPLES_NODE = "examples";
    private static final String EXAMPLE_VALUE_NODE = "value";
    private static final String EXAMPLE_PAYLOAD_NODE = "payload";
    private static final String QUEUE_VALUE = "queue";
    private static final String TOPIC_VALUE = "topic";

    public AsyncAPIImporter(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        super(specificationFilePath, referenceResolver);
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.rootSpecification.path("info").path("title").asText());
        service.setVersion(this.rootSpecification.path("info").path("version").asText());
        service.setType(ServiceType.EVENT);
        if (this.rootSpecification.path("info").has("x-microcks")) {
            Metadata metadata = new Metadata();
            MetadataExtractor.completeMetadata(metadata, this.rootSpecification.path("info").path("x-microcks"));
            service.setMetadata(metadata);
        }
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        HashMap<String, Resource> resolvedExternalRefResources = new HashMap<String, Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = Boolean.TRUE.equals(this.isYaml) ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.ASYNC_API_SPEC);
        results.add(resource);
        if (this.referenceResolver != null) {
            for (Operation operation : service.getOperations()) {
                JsonNode payloadNode;
                String[] operationElements = operation.getName().split(" ");
                String messageNamePtr = "/channels/" + operationElements[1].replace("/", "~1");
                JsonNode messageNode = this.rootSpecification.at(messageNamePtr = messageNamePtr + "/" + operationElements[0].toLowerCase() + "/message");
                if (messageNode == null || !(messageNode = this.followRefIfAny(messageNode)).has(EXAMPLE_PAYLOAD_NODE) || !(payloadNode = messageNode.path(EXAMPLE_PAYLOAD_NODE)).has("$ref")) continue;
                HashSet<String> references = new HashSet<String>();
                this.findAllExternalRefsAsyncAPI(payloadNode, references);
                for (String ref : references) {
                    Resource schemaResource = (Resource)resolvedExternalRefResources.get(ref);
                    if (schemaResource == null) {
                        try {
                            if (ref.contains("#")) {
                                ref = ref.substring(0, ref.indexOf("#"));
                            }
                            String content = this.referenceResolver.getHttpReferenceContent(ref, StandardCharsets.UTF_8);
                            String resourceName = ref.substring(ref.lastIndexOf(47) + 1);
                            schemaResource = new Resource();
                            schemaResource.setName(IdBuilder.buildResourceFullName((Service)service, (String)resourceName));
                            schemaResource.setPath(ref);
                            schemaResource.setContent(content);
                            if (messageNode.has("schemaFormat")) {
                                String schemaFormat = messageNode.path("schemaFormat").asText();
                                if (schemaFormat.startsWith("application/vnd.aai.asyncapi")) {
                                    schemaResource.setType(ResourceType.ASYNC_API_SCHEMA);
                                } else if (schemaFormat.startsWith("application/vnd.oai.openapi")) {
                                    schemaResource.setType(ResourceType.OPEN_API_SCHEMA);
                                } else if (schemaFormat.startsWith("application/schema+json") || schemaFormat.startsWith("application/schema+yaml")) {
                                    schemaResource.setType(ResourceType.JSON_SCHEMA);
                                } else if (schemaFormat.startsWith("application/vnd.apache.avro")) {
                                    schemaResource.setType(ResourceType.AVRO_SCHEMA);
                                }
                            } else {
                                schemaResource.setType(ResourceType.JSON_SCHEMA);
                            }
                            if (!ref.startsWith("http")) {
                                this.rootSpecificationContent = this.rootSpecificationContent.replace(ref, URLEncoder.encode(schemaResource.getName(), "UTF-8"));
                            }
                            results.add(schemaResource);
                        }
                        catch (IOException ioe) {
                            log.error("IOException while trying to resolve reference " + ref, (Throwable)ioe);
                            log.info("Ignoring the reference {} cause it could not be resolved", (Object)ref);
                        }
                        resolvedExternalRefResources.put(ref, schemaResource);
                    }
                    if (schemaResource != null) {
                        schemaResource.addOperation(operation.getName());
                        continue;
                    }
                    log.warn("Cannot add operation because schema resourse is null");
                }
            }
            this.referenceResolver.cleanResolvedReferences();
        }
        resource.setContent(this.rootSpecificationContent);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        ArrayList<Exchange> result = new ArrayList<Exchange>();
        String defaultContentType = "application/json";
        if (this.rootSpecification.has("defaultContentType")) {
            defaultContentType = this.rootSpecification.get("defaultContentType").asText("application/json");
        }
        Iterator channels = this.rootSpecification.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Map<String, Map<String, String>> pathParametersByExample = this.extractParametersByExample((JsonNode)channel.getValue());
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!operation.getName().equals(verbName.toUpperCase() + " " + channelName.trim())) continue;
                JsonNode messageBody = ((JsonNode)verb.getValue()).path("message");
                List<JsonNode> messageBodies = this.followRefsIfAny(messageBody);
                for (JsonNode extractedMsgBody : messageBodies) {
                    String contentType = defaultContentType;
                    if (extractedMsgBody.has("contentType")) {
                        contentType = extractedMsgBody.path("contentType").asText();
                    }
                    if (!extractedMsgBody.has(EXAMPLES_NODE)) continue;
                    Iterator examples = extractedMsgBody.path(EXAMPLES_NODE).elements();
                    int exampleIndex = 0;
                    while (examples.hasNext()) {
                        JsonNode exampleNode = (JsonNode)examples.next();
                        EventMessage eventMessage = null;
                        eventMessage = exampleNode.has("name") ? this.extractFromAsyncAPI21Example(contentType, exampleNode) : (exampleNode.has(EXAMPLE_PAYLOAD_NODE) ? this.extractFromAsyncAPIExample(contentType, exampleNode, channelName.trim() + "-" + exampleIndex) : this.extractFromMicrocksExample(contentType, exampleNode));
                        if (eventMessage != null) {
                            if ("URI_PARTS".equals(operation.getDispatcher())) {
                                String resourcePathPattern = channelName;
                                Map<String, String> parts = pathParametersByExample.get(eventMessage.getName());
                                String resourcePath = URIBuilder.buildURIFromPattern(resourcePathPattern, parts);
                                operation.addResourcePath(resourcePath);
                                eventMessage.setDispatchCriteria(DispatchCriteriaHelper.buildFromPartsMap(operation.getDispatcherRules(), parts));
                            }
                            result.add((Exchange)new UnidirectionalEvent(eventMessage));
                        }
                        ++exampleIndex;
                    }
                }
            }
        }
        return result;
    }

    private List<Operation> extractOperations() throws MockRepositoryImportException {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator channels = this.rootSpecification.path("channels").fields();
        while (channels.hasNext()) {
            Map.Entry channel = (Map.Entry)channels.next();
            String channelName = (String)channel.getKey();
            Iterator verbs = ((JsonNode)channel.getValue()).fields();
            while (verbs.hasNext()) {
                Binding b;
                JsonNode binding;
                String bindingName;
                Iterator bindingNames;
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!VALID_VERBS.contains(verbName)) continue;
                String operationName = verbName.toUpperCase() + " " + channelName.trim();
                Operation operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(verbName.toUpperCase());
                if (((JsonNode)verb.getValue()).has("x-microcks-operation")) {
                    MetadataExtractor.completeOperationProperties(operation, ((JsonNode)verb.getValue()).path("x-microcks-operation"));
                }
                if (operation.getDispatcher() == null && AsyncAPIImporter.channelHasParts(channelName)) {
                    operation.setDispatcher("URI_PARTS");
                    operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(channelName));
                } else {
                    operation.addResourcePath(channelName);
                }
                if (((JsonNode)channel.getValue()).has(BINDINGS)) {
                    bindingNames = ((JsonNode)channel.getValue()).path(BINDINGS).fieldNames();
                    block39: while (bindingNames.hasNext()) {
                        bindingName = (String)bindingNames.next();
                        binding = ((JsonNode)channel.getValue()).path(BINDINGS).path(bindingName);
                        switch (bindingName) {
                            case "ws": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.WS);
                                if (!binding.has("method")) break;
                                b.setMethod(binding.path("method").asText());
                                break;
                            }
                            case "amqp": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.AMQP);
                                if (!binding.has("is")) break;
                                String is = binding.path("is").asText();
                                if (QUEUE_VALUE.equals(is)) {
                                    b.setDestinationType(QUEUE_VALUE);
                                    JsonNode queue = binding.get(QUEUE_VALUE);
                                    b.setDestinationName(queue.get("name").asText());
                                    break;
                                }
                                if (!"routingKey".equals(is)) continue block39;
                                JsonNode exchange = binding.get("exchange");
                                b.setDestinationType(exchange.get("type").asText());
                                break;
                            }
                            case "googlepubsub": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.GOOGLEPUBSUB);
                                if (binding.has(TOPIC_VALUE)) {
                                    b.setDestinationName(binding.get(TOPIC_VALUE).asText());
                                }
                                if (!binding.has("messageRetentionDuration")) break;
                                b.setPersistent(true);
                                break;
                            }
                        }
                    }
                }
                if (((JsonNode)verb.getValue()).has(BINDINGS)) {
                    bindingNames = ((JsonNode)verb.getValue()).path(BINDINGS).fieldNames();
                    while (bindingNames.hasNext()) {
                        bindingName = (String)bindingNames.next();
                        binding = ((JsonNode)verb.getValue()).path(BINDINGS).path(bindingName);
                        switch (bindingName) {
                            case "kafka": {
                                break;
                            }
                            case "mqtt": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.MQTT);
                                if (binding.has("qos")) {
                                    b.setQoS(binding.path("qos").asText());
                                }
                                if (!binding.has("retain")) break;
                                b.setPersistent(binding.path("retain").asBoolean());
                                break;
                            }
                            case "amqp1": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.AMQP1);
                                if (binding.has("destinationName")) {
                                    b.setDestinationName(binding.path("destinationName").asText());
                                }
                                if (!binding.has("destinationType")) break;
                                b.setDestinationType(binding.path("destinationType").asText());
                                break;
                            }
                            case "nats": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.NATS);
                                if (!binding.has(QUEUE_VALUE)) break;
                                b.setDestinationName(binding.path(QUEUE_VALUE).asText());
                                break;
                            }
                            case "sqs": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.SQS);
                                if (!binding.has(QUEUE_VALUE)) break;
                                if (binding.get(QUEUE_VALUE).has("name")) {
                                    b.setDestinationName(binding.get(QUEUE_VALUE).get("name").asText());
                                }
                                if (!binding.has("messageRetentionPeriod")) break;
                                b.setPersistent(true);
                                break;
                            }
                            case "sns": {
                                b = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.SNS);
                                if (!binding.has(TOPIC_VALUE) || !binding.get(TOPIC_VALUE).has("name")) break;
                                b.setDestinationName(binding.get(TOPIC_VALUE).get("name").asText());
                                break;
                            }
                        }
                    }
                }
                JsonNode messageBody = ((JsonNode)verb.getValue()).path("message");
                if ((messageBody = this.followRefIfAny(messageBody)).has(BINDINGS)) {
                    Iterator bindingNames2 = messageBody.path(BINDINGS).fieldNames();
                    while (bindingNames2.hasNext()) {
                        String bindingName2 = (String)bindingNames2.next();
                        JsonNode binding2 = messageBody.path(BINDINGS).path(bindingName2);
                        switch (bindingName2) {
                            case "kafka": {
                                Binding b2 = AsyncAPIImporter.retrieveOrInitOperationBinding(operation, BindingType.KAFKA);
                                if (!binding2.has("key")) break;
                                b2.setKeyType(binding2.path("key").path("type").asText());
                                break;
                            }
                            case "nats": {
                                break;
                            }
                            case "mqtt": 
                            case "amqp1": {
                                break;
                            }
                        }
                    }
                }
                results.add(operation);
            }
        }
        return results;
    }

    private void findAllExternalRefsAsyncAPI(JsonNode node, Set<String> externalRefs) {
        if (node.has("$ref")) {
            String ref = node.path("$ref").asText();
            if (!ref.startsWith("#")) {
                externalRefs.add(ref);
            } else {
                this.findAllExternalRefsAsyncAPI(this.followRefIfAny(node), externalRefs);
            }
        } else {
            Iterator children = node.elements();
            while (children.hasNext()) {
                this.findAllExternalRefsAsyncAPI((JsonNode)children.next(), externalRefs);
            }
        }
    }

    private EventMessage extractFromAsyncAPI21Example(String contentType, JsonNode exampleNode) {
        String exampleName = exampleNode.path("name").asText();
        String exampleValue = this.getExamplePayload(exampleNode);
        EventMessage eventMessage = new EventMessage();
        eventMessage.setName(exampleName);
        eventMessage.setContent(exampleValue);
        eventMessage.setMediaType(contentType);
        List<Header> headers = this.getExampleHeaders(exampleNode);
        for (Header header : headers) {
            eventMessage.addHeader(header);
        }
        return eventMessage;
    }

    private EventMessage extractFromAsyncAPIExample(String contentType, JsonNode exampleNode, String exampleName) {
        String exampleValue = this.getExamplePayload(exampleNode);
        EventMessage eventMessage = new EventMessage();
        eventMessage.setName(exampleName);
        eventMessage.setContent(exampleValue);
        eventMessage.setMediaType(contentType);
        List<Header> headers = this.getExampleHeaders(exampleNode);
        for (Header header : headers) {
            eventMessage.addHeader(header);
        }
        return eventMessage;
    }

    private EventMessage extractFromMicrocksExample(String contentType, JsonNode exampleNode) {
        EventMessage eventMessage = null;
        Iterator exampleNames = exampleNode.fieldNames();
        while (exampleNames.hasNext()) {
            String exampleName = (String)exampleNames.next();
            JsonNode example = exampleNode.path(exampleName);
            if (!example.has(EXAMPLE_PAYLOAD_NODE)) continue;
            String exampleValue = this.getExamplePayload(example);
            eventMessage = new EventMessage();
            eventMessage.setName(exampleName);
            eventMessage.setContent(exampleValue);
            eventMessage.setMediaType(contentType);
            List<Header> headers = this.getExampleHeaders(example);
            for (Header header : headers) {
                eventMessage.addHeader(header);
            }
        }
        return eventMessage;
    }

    private List<Header> getExampleHeaders(JsonNode example) {
        ArrayList<Header> results = new ArrayList<Header>();
        if (example.has("headers")) {
            Iterator headers = null;
            if (example.path("headers").getNodeType() == JsonNodeType.OBJECT) {
                headers = example.path("headers").fields();
            } else if (example.path("headers").getNodeType() == JsonNodeType.STRING) {
                try {
                    ObjectMapper mapper = new ObjectMapper();
                    JsonNode headersNode = mapper.readTree(example.path("headers").asText());
                    headers = headersNode.fields();
                }
                catch (Exception e) {
                    log.warn("Headers value {} is a string but not JSON, skipping it", (Object)example.path("headers").asText());
                }
            }
            if (headers != null) {
                while (headers.hasNext()) {
                    Map.Entry property = (Map.Entry)headers.next();
                    Header header = new Header();
                    header.setName((String)property.getKey());
                    Set headerValues = Arrays.stream(((JsonNode)property.getValue()).asText().split(",")).map(String::trim).collect(Collectors.toSet());
                    header.setValues(headerValues);
                    results.add(header);
                }
            }
        }
        return results;
    }

    private String getExamplePayload(JsonNode example) {
        if (example.has(EXAMPLE_PAYLOAD_NODE)) {
            return this.getValueString(example.path(EXAMPLE_PAYLOAD_NODE));
        }
        if (example.has("$payloadRef")) {
            String ref = example.path("$payloadRef").asText();
            JsonNode component = this.rootSpecification.at(ref.substring(1));
            return this.getExamplePayload(component);
        }
        return null;
    }

    private static boolean channelHasParts(String channel) {
        return channel.indexOf("/{") != -1;
    }

    private Map<String, Map<String, String>> extractParametersByExample(JsonNode node) {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        Iterator parameters = node.path("parameters").fields();
        while (parameters.hasNext()) {
            Map.Entry parameterEntry = (Map.Entry)parameters.next();
            JsonNode parameter = (JsonNode)parameterEntry.getValue();
            parameter = this.followRefIfAny(parameter);
            String parameterName = (String)parameterEntry.getKey();
            log.debug("Processing param {}", (Object)parameterName);
            if (!parameter.has(SCHEMA_NODE) || !parameter.path(SCHEMA_NODE).has(EXAMPLES_NODE)) continue;
            Iterator exampleNames = parameter.path(SCHEMA_NODE).path(EXAMPLES_NODE).fieldNames();
            while (exampleNames.hasNext()) {
                String exampleName = (String)exampleNames.next();
                log.debug("Processing example {}", (Object)exampleName);
                JsonNode example = parameter.path(SCHEMA_NODE).path(EXAMPLES_NODE).path(exampleName);
                String exampleValue = this.getExampleValue(example);
                log.debug("{} {} {}", new Object[]{parameterName, exampleName, exampleValue});
                HashMap<String, String> exampleParams = (HashMap<String, String>)results.get(exampleName);
                if (exampleParams == null) {
                    exampleParams = new HashMap<String, String>();
                    results.put(exampleName, exampleParams);
                }
                exampleParams.put(parameterName, exampleValue);
            }
        }
        return results;
    }

    private String getExampleValue(JsonNode example) {
        if (example.has(EXAMPLE_VALUE_NODE)) {
            JsonNode valueNode = this.followRefIfAny(example.path(EXAMPLE_VALUE_NODE));
            return this.getValueString(valueNode);
        }
        if (example.has("$ref")) {
            JsonNode component = this.followRefIfAny(example);
            return this.getExampleValue(component);
        }
        return null;
    }

    private List<JsonNode> followRefsIfAny(JsonNode referencableNode) {
        ArrayList<JsonNode> results = new ArrayList<JsonNode>();
        if (referencableNode.has("$ref")) {
            String ref = referencableNode.path("$ref").asText();
            results.add(this.rootSpecification.at(ref.substring(1)));
        } else {
            for (String structure : MULTI_STRUCTURES) {
                if (!referencableNode.has(structure) || !referencableNode.path(structure).isArray()) continue;
                ArrayNode arrayNode = (ArrayNode)referencableNode.path(structure);
                for (int i = 0; i < arrayNode.size(); ++i) {
                    JsonNode structureNode = arrayNode.get(i);
                    results.add(this.followRefIfAny(structureNode));
                }
            }
        }
        if (results.isEmpty()) {
            results.add(referencableNode);
        }
        return results;
    }

    private static Binding retrieveOrInitOperationBinding(Operation operation, BindingType type) {
        Binding binding = null;
        if (operation.getBindings() != null) {
            binding = (Binding)operation.getBindings().get(type.toString());
        }
        if (binding == null) {
            binding = new Binding(type);
            operation.addBinding(type.toString(), binding);
        }
        return binding;
    }
}

