/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.openapi;

import com.fasterxml.jackson.databind.JsonNode;
import io.github.microcks.domain.Exchange;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Metadata;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.RequestResponsePair;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.ServiceType;
import io.github.microcks.util.AbstractJsonRepositoryImporter;
import io.github.microcks.util.DispatchCriteriaHelper;
import io.github.microcks.util.MockRepositoryImportException;
import io.github.microcks.util.MockRepositoryImporter;
import io.github.microcks.util.ReferenceResolver;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.dispatcher.FallbackSpecification;
import io.github.microcks.util.dispatcher.JsonMappingException;
import io.github.microcks.util.metadata.MetadataExtractor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIImporter
extends AbstractJsonRepositoryImporter
implements MockRepositoryImporter {
    private static Logger log = LoggerFactory.getLogger(OpenAPIImporter.class);
    private static final List<String> VALID_VERBS = Arrays.asList("get", "put", "post", "delete", "options", "head", "patch", "trace");
    private static final String PARAMETERS_NODE = "parameters";
    private static final String PARAMETERS_QUERY_VALUE = "query";
    private static final String CONTENT_NODE = "content";
    private static final String EXAMPLES_NODE = "examples";
    private static final String EXAMPLE_VALUE_NODE = "value";

    public OpenAPIImporter(String specificationFilePath, ReferenceResolver referenceResolver) throws IOException {
        super(specificationFilePath, referenceResolver);
    }

    @Override
    public List<Service> getServiceDefinitions() throws MockRepositoryImportException {
        ArrayList<Service> result = new ArrayList<Service>();
        Service service = new Service();
        service.setName(this.rootSpecification.path("info").path("title").asText());
        service.setVersion(this.rootSpecification.path("info").path("version").asText());
        service.setType(ServiceType.REST);
        if (this.rootSpecification.path("info").has("x-microcks")) {
            Metadata metadata = new Metadata();
            MetadataExtractor.completeMetadata(metadata, this.rootSpecification.path("info").path("x-microcks"));
            service.setMetadata(metadata);
        }
        this.initializeReferencedResources(service);
        service.setOperations(this.extractOperations());
        result.add(service);
        return result;
    }

    @Override
    public List<Resource> getResourceDefinitions(Service service) {
        ArrayList<Resource> results = new ArrayList<Resource>();
        String name = service.getName() + "-" + service.getVersion();
        name = Boolean.TRUE.equals(this.isYaml) ? name + ".yaml" : name + ".json";
        Resource resource = new Resource();
        resource.setName(name);
        resource.setType(ResourceType.OPEN_API_SPEC);
        results.add(resource);
        resource.setContent(this.rootSpecificationContent);
        results.addAll(this.externalResources);
        return results;
    }

    @Override
    public List<Exchange> getMessageDefinitions(Service service, Operation operation) throws MockRepositoryImportException {
        HashMap<Request, Response> result = new HashMap<Request, Response>();
        Iterator paths = this.rootSpecification.path("paths").fields();
        while (paths.hasNext()) {
            Map.Entry path = (Map.Entry)paths.next();
            String pathName = (String)path.getKey();
            JsonNode pathValue = this.followRefIfAny((JsonNode)path.getValue());
            Map<String, Map<String, String>> pathPathParametersByExample = this.extractParametersByExample(pathValue, "path");
            Iterator verbs = pathValue.fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!operation.getName().equals(verbName.toUpperCase() + " " + pathName.trim())) continue;
                Map<String, Map<String, String>> pathParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), "path");
                pathParametersByExample.putAll(pathPathParametersByExample);
                Map<String, Map<String, String>> queryParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE);
                Map<String, Map<String, String>> headerParametersByExample = this.extractParametersByExample((JsonNode)verb.getValue(), "header");
                Map<String, Request> requestBodiesByExample = this.extractRequestBodies((JsonNode)verb.getValue());
                if (!((JsonNode)verb.getValue()).has("responses")) continue;
                String rootDispatcher = operation.getDispatcher();
                String rootDispatcherRules = operation.getDispatcherRules();
                if ("FALLBACK".equals(operation.getDispatcher())) {
                    FallbackSpecification fallbackSpec = null;
                    try {
                        fallbackSpec = FallbackSpecification.buildFromJsonString(operation.getDispatcherRules());
                        rootDispatcher = fallbackSpec.getDispatcher();
                        rootDispatcherRules = fallbackSpec.getDispatcherRules();
                    }
                    catch (JsonMappingException e) {
                        log.warn("Operation '{}' has a malformed Fallback dispatcher rules", (Object)operation.getName());
                    }
                }
                Iterator responseCodes = ((JsonNode)verb.getValue()).path("responses").fields();
                while (responseCodes.hasNext()) {
                    Map.Entry responseCode = (Map.Entry)responseCodes.next();
                    Map<String, List<Header>> headersByExample = this.extractHeadersByExample((JsonNode)responseCode.getValue());
                    Iterator contents = this.getResponseContent((JsonNode)responseCode.getValue()).fields();
                    block5: while (contents.hasNext()) {
                        Map.Entry content = (Map.Entry)contents.next();
                        String contentValue = (String)content.getKey();
                        JsonNode examplesNode = ((JsonNode)content.getValue()).path(EXAMPLES_NODE);
                        if (examplesNode.has("$ref")) {
                            examplesNode = this.followRefIfAny(examplesNode);
                        }
                        Iterator exampleNames = examplesNode.fieldNames();
                        while (exampleNames.hasNext()) {
                            Map<String, String> map;
                            Map<String, String> queryParameters;
                            Request request;
                            List<Header> responseHeaders;
                            String exampleName = (String)exampleNames.next();
                            JsonNode example = examplesNode.path(exampleName);
                            Response response = new Response();
                            response.setName(exampleName);
                            response.setMediaType(contentValue);
                            response.setStatus((String)responseCode.getKey());
                            response.setContent(this.getExampleValue(example));
                            if (!((String)responseCode.getKey()).startsWith("2")) {
                                response.setFault(true);
                            }
                            if ((responseHeaders = headersByExample.get(exampleName)) != null) {
                                responseHeaders.stream().forEach(arg_0 -> ((Response)response).addHeader(arg_0));
                            }
                            if ((request = requestBodiesByExample.get(exampleName)) == null) {
                                request = new Request();
                                request.setName(exampleName);
                            }
                            Header header = new Header();
                            header.setName("Accept");
                            HashSet<String> values = new HashSet<String>();
                            values.add(contentValue);
                            header.setValues(values);
                            request.addHeader(header);
                            Map<String, String> pathParameters = pathParametersByExample.get(exampleName);
                            if (pathParameters != null) {
                                for (Map.Entry<String, String> entry2 : pathParameters.entrySet()) {
                                    Parameter param = new Parameter();
                                    param.setName(entry2.getKey());
                                    param.setValue(entry2.getValue());
                                    request.addQueryParameter(param);
                                }
                            } else if ("URI_PARTS".equals(operation.getDispatcher()) || "URI_ELEMENTS".equals(operation.getDispatcher())) continue block5;
                            if ((queryParameters = queryParametersByExample.get(exampleName)) != null) {
                                for (Object paramEntry2 : queryParameters.entrySet()) {
                                    Parameter parameter = new Parameter();
                                    parameter.setName((String)paramEntry2.getKey());
                                    parameter.setValue((String)paramEntry2.getValue());
                                    request.addQueryParameter(parameter);
                                }
                            }
                            if ((map = headerParametersByExample.get(exampleName)) != null) {
                                Object paramEntry2;
                                paramEntry2 = map.entrySet().iterator();
                                while (paramEntry2.hasNext()) {
                                    Map.Entry entry3 = (Map.Entry)paramEntry2.next();
                                    header = new Header();
                                    header.setName((String)entry3.getKey());
                                    Set headerValues = Arrays.stream(((String)entry3.getValue()).split(",")).map(String::trim).collect(Collectors.toSet());
                                    header.setValues(headerValues);
                                    request.addHeader(header);
                                }
                            }
                            Object dispatchCriteria = null;
                            String string = operation.getName().split(" ")[1];
                            if ("URI_PARAMS".equals(rootDispatcher)) {
                                Map<String, String> queryParams = queryParametersByExample.get(exampleName);
                                dispatchCriteria = DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, queryParams);
                                operation.addResourcePath(string);
                            } else if ("URI_PARTS".equals(rootDispatcher)) {
                                parts = pathParametersByExample.get(exampleName);
                                dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
                                String resourcePath = URIBuilder.buildURIFromPattern(string, parts);
                                operation.addResourcePath(resourcePath);
                            } else if ("URI_ELEMENTS".equals(rootDispatcher)) {
                                parts = pathParametersByExample.get(exampleName);
                                Map<String, String> queryParams = queryParametersByExample.get(exampleName);
                                dispatchCriteria = DispatchCriteriaHelper.buildFromPartsMap(rootDispatcherRules, parts);
                                dispatchCriteria = (String)dispatchCriteria + DispatchCriteriaHelper.buildFromParamsMap(rootDispatcherRules, queryParams);
                                String resourcePath = URIBuilder.buildURIFromPattern(string, parts);
                                operation.addResourcePath(resourcePath);
                            }
                            response.setDispatchCriteria((String)dispatchCriteria);
                            result.put(request, response);
                        }
                    }
                }
            }
        }
        return result.entrySet().stream().map(entry -> new RequestResponsePair((Request)entry.getKey(), (Response)entry.getValue())).collect(Collectors.toList());
    }

    private List<Operation> extractOperations() throws MockRepositoryImportException {
        ArrayList<Operation> results = new ArrayList<Operation>();
        Iterator paths = this.rootSpecification.path("paths").fields();
        while (paths.hasNext()) {
            Map.Entry path = (Map.Entry)paths.next();
            String pathName = (String)path.getKey();
            JsonNode pathValue = this.followRefIfAny((JsonNode)path.getValue());
            Iterator verbs = pathValue.fields();
            while (verbs.hasNext()) {
                Map.Entry verb = (Map.Entry)verbs.next();
                String verbName = (String)verb.getKey();
                if (!VALID_VERBS.contains(verbName)) continue;
                String operationName = verbName.toUpperCase() + " " + pathName.trim();
                Operation operation = new Operation();
                operation.setName(operationName);
                operation.setMethod(verbName.toUpperCase());
                if (((JsonNode)verb.getValue()).has("x-microcks-operation")) {
                    MetadataExtractor.completeOperationProperties(operation, ((JsonNode)verb.getValue()).path("x-microcks-operation"));
                }
                if (operation.getDispatcher() == null) {
                    if (this.operationHasParameters((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE) && OpenAPIImporter.urlHasParts(pathName)) {
                        operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(pathName) + " ?? " + this.extractOperationParams((JsonNode)verb.getValue()));
                        operation.setDispatcher("URI_ELEMENTS");
                    } else if (this.operationHasParameters((JsonNode)verb.getValue(), PARAMETERS_QUERY_VALUE)) {
                        operation.setDispatcherRules(this.extractOperationParams((JsonNode)verb.getValue()));
                        operation.setDispatcher("URI_PARAMS");
                    } else if (OpenAPIImporter.urlHasParts(pathName)) {
                        operation.setDispatcherRules(DispatchCriteriaHelper.extractPartsFromURIPattern(pathName));
                        operation.setDispatcher("URI_PARTS");
                    } else {
                        operation.addResourcePath(pathName);
                    }
                } else {
                    operation.addResourcePath(pathName);
                }
                results.add(operation);
            }
        }
        return results;
    }

    private Map<String, Map<String, String>> extractParametersByExample(JsonNode node, String parameterType) {
        HashMap<String, Map<String, String>> results = new HashMap<String, Map<String, String>>();
        Iterator parameters = node.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterName = parameter.path("name").asText();
            if (!parameter.has("in") || !parameter.path("in").asText().equals(parameterType) || !parameter.has(EXAMPLES_NODE)) continue;
            Iterator exampleNames = parameter.path(EXAMPLES_NODE).fieldNames();
            while (exampleNames.hasNext()) {
                String exampleName = (String)exampleNames.next();
                JsonNode example = parameter.path(EXAMPLES_NODE).path(exampleName);
                String exampleValue = this.getExampleValue(example);
                HashMap<String, String> exampleParams = (HashMap<String, String>)results.get(exampleName);
                if (exampleParams == null) {
                    exampleParams = new HashMap<String, String>();
                    results.put(exampleName, exampleParams);
                }
                exampleParams.put(parameterName, exampleValue);
            }
        }
        return results;
    }

    private Map<String, Request> extractRequestBodies(JsonNode verbNode) {
        HashMap<String, Request> results = new HashMap<String, Request>();
        JsonNode requestBody = verbNode.path("requestBody");
        Iterator contentTypeNames = requestBody.path(CONTENT_NODE).fieldNames();
        while (contentTypeNames.hasNext()) {
            String contentTypeName = (String)contentTypeNames.next();
            JsonNode contentType = requestBody.path(CONTENT_NODE).path(contentTypeName);
            if (!contentType.has(EXAMPLES_NODE)) continue;
            Iterator exampleNames = contentType.path(EXAMPLES_NODE).fieldNames();
            while (exampleNames.hasNext()) {
                String exampleName = (String)exampleNames.next();
                JsonNode example = contentType.path(EXAMPLES_NODE).path(exampleName);
                String exampleValue = this.getExampleValue(example);
                Request request = new Request();
                request.setName(exampleName);
                request.setContent(exampleValue);
                Header header = new Header();
                header.setName("Content-Type");
                HashSet<String> values = new HashSet<String>();
                values.add(contentTypeName);
                header.setValues(values);
                request.addHeader(header);
                results.put(exampleName, request);
            }
        }
        return results;
    }

    private Map<String, List<Header>> extractHeadersByExample(JsonNode responseNode) {
        HashMap<String, List<Header>> results = new HashMap<String, List<Header>>();
        if (responseNode.has("headers")) {
            JsonNode headersNode = responseNode.path("headers");
            Iterator headerNames = headersNode.fieldNames();
            while (headerNames.hasNext()) {
                String headerName = (String)headerNames.next();
                JsonNode headerNode = headersNode.path(headerName);
                if (!headerNode.has(EXAMPLES_NODE)) continue;
                Iterator exampleNames = headerNode.path(EXAMPLES_NODE).fieldNames();
                while (exampleNames.hasNext()) {
                    String exampleName = (String)exampleNames.next();
                    JsonNode example = headerNode.path(EXAMPLES_NODE).path(exampleName);
                    String exampleValue = this.getExampleValue(example);
                    Set values = Arrays.stream(exampleValue.split(",")).map(String::trim).collect(Collectors.toSet());
                    Header header = new Header();
                    header.setName(headerName);
                    header.setValues(values);
                    ArrayList<Header> headersForExample = (ArrayList<Header>)results.get(exampleName);
                    if (headersForExample == null) {
                        headersForExample = new ArrayList<Header>();
                    }
                    headersForExample.add(header);
                    results.put(exampleName, headersForExample);
                }
            }
        }
        if (responseNode.has("$ref")) {
            JsonNode component = this.followRefIfAny(responseNode);
            return this.extractHeadersByExample(component);
        }
        return results;
    }

    private String getExampleValue(JsonNode example) {
        if (example.has(EXAMPLE_VALUE_NODE)) {
            JsonNode valueNode = this.followRefIfAny(example.path(EXAMPLE_VALUE_NODE));
            return this.getValueString(valueNode);
        }
        if (example.has("$ref")) {
            JsonNode component = this.followRefIfAny(example);
            return this.getExampleValue(component);
        }
        return null;
    }

    private JsonNode getResponseContent(JsonNode response) {
        if (response.has("$ref")) {
            JsonNode component = this.followRefIfAny(response);
            return this.getResponseContent(component);
        }
        return response.path(CONTENT_NODE);
    }

    private String extractOperationParams(JsonNode operation) {
        StringBuilder params = new StringBuilder();
        Iterator parameters = operation.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterIn = parameter.path("in").asText();
            if ("path".equals(parameterIn)) continue;
            if (params.length() > 0) {
                params.append(" && ");
            }
            params.append(parameter.path("name").asText());
        }
        return params.toString();
    }

    private boolean operationHasParameters(JsonNode operation, String parameterType) {
        if (!operation.has(PARAMETERS_NODE)) {
            return false;
        }
        Iterator parameters = operation.path(PARAMETERS_NODE).elements();
        while (parameters.hasNext()) {
            JsonNode parameter = this.followRefIfAny((JsonNode)parameters.next());
            String parameterIn = parameter.path("in").asText();
            if (!parameterIn.equals(parameterType)) continue;
            return true;
        }
        return false;
    }

    private static boolean urlHasParts(String url) {
        return url.indexOf("/:") != -1 || url.indexOf("/{") != -1;
    }
}

