/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.web.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DynamicOriginCorsFilter
implements Filter {
    private final String corsAllowedOrigins;
    private final Boolean corsAllowCredentials;

    public DynamicOriginCorsFilter(String corsAllowedOrigins, Boolean corsAllowCredentials) {
        this.corsAllowedOrigins = corsAllowedOrigins;
        this.corsAllowCredentials = corsAllowCredentials;
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String origin = httpRequest.getHeader("Origin");
        if (origin == null) {
            origin = this.corsAllowedOrigins;
        }
        response.setHeader("Access-Control-Allow-Origin", origin);
        response.setHeader("Access-Control-Allow-Methods", "POST, PUT, GET, OPTIONS, DELETE");
        response.setHeader("Access-Control-Max-Age", "3600");
        response.setHeader("Access-Control-Allow-Headers", "*");
        if (Boolean.TRUE.equals(this.corsAllowCredentials)) {
            response.setHeader("Access-Control-Allow-Credentials", "true");
        }
        chain.doFilter(servletRequest, servletResponse);
    }
}

