/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import io.github.microcks.domain.Parameter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.springframework.web.util.UriUtils;

public class URIBuilder {
    private URIBuilder() {
    }

    public static String buildURIFromPattern(String pattern, List<Parameter> parameters) {
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String wadlTemplate = "{" + parameter.getName() + "}";
                String swaggerTemplate = "/:" + parameter.getName();
                if (((String)pattern).contains(wadlTemplate)) {
                    pattern = ((String)pattern).replace(wadlTemplate, URIBuilder.encodePath(parameter.getValue()));
                    continue;
                }
                if (((String)pattern).contains(swaggerTemplate)) {
                    pattern = ((String)pattern).replace(":" + parameter.getName(), URIBuilder.encodePath(parameter.getValue()));
                    continue;
                }
                if (!((String)pattern).contains("?")) {
                    pattern = (String)pattern + "?";
                }
                if (((String)pattern).contains("=")) {
                    pattern = (String)pattern + "&";
                }
                pattern = (String)pattern + parameter.getName() + "=" + URIBuilder.encodeValue(parameter.getValue());
            }
        }
        return pattern;
    }

    public static String buildURIFromPattern(String pattern, Map<String, String> parameters) {
        if (parameters != null) {
            Multimap multimap = (Multimap)parameters.entrySet().stream().collect(ArrayListMultimap::create, (m, e) -> m.put((Object)((String)e.getKey()), (Object)((String)e.getValue())), Multimap::putAll);
            return URIBuilder.buildURIFromPattern(pattern, (Multimap<String, String>)multimap);
        }
        return pattern;
    }

    public static String buildURIFromPattern(String pattern, Multimap<String, String> parameters) {
        if (parameters != null) {
            for (String parameterName : parameters.keySet()) {
                String wadltemplate = "{" + parameterName + "}";
                String swaggerTemplate = "/:" + parameterName;
                for (String parameterValue : parameters.get((Object)parameterName)) {
                    if (((String)pattern).contains(wadltemplate)) {
                        pattern = ((String)pattern).replace(wadltemplate, URIBuilder.encodePath(parameterValue));
                        continue;
                    }
                    if (((String)pattern).contains(swaggerTemplate)) {
                        pattern = ((String)pattern).replace(":" + parameterName, URIBuilder.encodePath(parameterValue));
                        continue;
                    }
                    if (!((String)pattern).contains("?")) {
                        pattern = (String)pattern + "?";
                    }
                    if (((String)pattern).contains("=")) {
                        pattern = (String)pattern + "&";
                    }
                    pattern = (String)pattern + parameterName + "=" + URIBuilder.encodeValue(parameterValue);
                }
            }
        }
        return pattern;
    }

    private static final String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex.getCause());
        }
    }

    private static final String encodePath(String path) {
        return UriUtils.encodePath((String)path, (String)"UTF-8");
    }
}

