/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.util.postman;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.github.microcks.domain.Header;
import io.github.microcks.domain.Operation;
import io.github.microcks.domain.Parameter;
import io.github.microcks.domain.Request;
import io.github.microcks.domain.Resource;
import io.github.microcks.domain.ResourceType;
import io.github.microcks.domain.Response;
import io.github.microcks.domain.Service;
import io.github.microcks.domain.TestResult;
import io.github.microcks.domain.TestReturn;
import io.github.microcks.repository.ResourceRepository;
import io.github.microcks.util.URIBuilder;
import io.github.microcks.util.postman.PostmanCollectionImporter;
import io.github.microcks.util.postman.PostmanUtil;
import io.github.microcks.util.test.AbstractTestRunner;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;

public class PostmanTestStepsRunner
extends AbstractTestRunner<HttpMethod> {
    private static Logger log = LoggerFactory.getLogger(PostmanTestStepsRunner.class);
    private ObjectMapper mapper = new ObjectMapper();
    private JsonNode collection;
    private ResourceRepository resourceRepository;
    private ClientHttpRequestFactory clientHttpRequestFactory;
    private String testsCallbackUrl = null;
    private String postmanRunnerUrl = null;

    public PostmanTestStepsRunner(ResourceRepository resourceRepository) {
        this.resourceRepository = resourceRepository;
    }

    public void setClientHttpRequestFactory(ClientHttpRequestFactory clientHttpRequestFactory) {
        this.clientHttpRequestFactory = clientHttpRequestFactory;
    }

    public void setTestsCallbackUrl(String testsCallbackUrl) {
        this.testsCallbackUrl = testsCallbackUrl;
    }

    public void setPostmanRunnerUrl(String postmanRunnerUrl) {
        this.postmanRunnerUrl = postmanRunnerUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TestReturn> runTest(Service service, Operation operation, TestResult testResult, List<Request> requests, String endpointUrl, HttpMethod method) throws URISyntaxException, IOException {
        if (log.isDebugEnabled()) {
            log.debug("Launching test run on {} for {} request(s)", (Object)endpointUrl, (Object)requests.size());
        }
        Resource collectionResource = null;
        List<Resource> resources = this.resourceRepository.findByServiceId(service.getId());
        for (Resource resource : resources) {
            if (!ResourceType.POSTMAN_COLLECTION.equals((Object)resource.getType())) continue;
            collectionResource = resource;
            break;
        }
        try {
            this.collection = this.mapper.readTree(collectionResource.getContent());
        }
        catch (Exception e) {
            throw new IOException("Postman collection file cannot be found or parsed", e);
        }
        if (endpointUrl.endsWith("/")) {
            endpointUrl = endpointUrl.substring(0, endpointUrl.length() - 1);
        }
        ObjectNode jsonArg = this.mapper.createObjectNode();
        jsonArg.put("operation", operation.getName());
        jsonArg.put("callbackUrl", this.testsCallbackUrl + "/api/tests/" + testResult.getId() + "/testCaseResult");
        JsonNode testScript = this.extractOperationTestScript(operation);
        if (testScript == null) {
            log.info("No testScript found for operation '{}', marking it as failed", (Object)operation.getName());
            return requests.stream().map(request -> new TestReturn(1, 0L, "Not executed cause no Test Script found for this operation", request, new Response())).toList();
        }
        log.debug("Found a testScript for this operation !");
        jsonArg.set("testScript", testScript);
        ArrayNode jsonRequests = this.mapper.createArrayNode();
        for (Request request2 : requests) {
            ObjectNode jsonRequest = this.mapper.createObjectNode();
            String operationName = operation.getName().substring(operation.getName().indexOf(" ") + 1);
            String customizedEndpointUrl = endpointUrl + URIBuilder.buildURIFromPattern(operationName, request2.getQueryParameters());
            log.debug("Using customized endpoint url: {}", (Object)customizedEndpointUrl);
            jsonRequest.put("endpointUrl", customizedEndpointUrl);
            jsonRequest.put("method", operation.getMethod());
            jsonRequest.put("name", request2.getName());
            if (request2.getContent() != null && !request2.getContent().isEmpty()) {
                jsonRequest.put("body", request2.getContent());
            }
            if (request2.getQueryParameters() != null && !request2.getQueryParameters().isEmpty()) {
                ArrayNode jsonParams = this.buildQueryParams(request2.getQueryParameters());
                jsonRequest.set("queryParams", (JsonNode)jsonParams);
            }
            HashSet<Header> headers = new HashSet<Header>();
            if (request2.getHeaders() != null) {
                headers.addAll(request2.getHeaders());
            }
            if (testResult.getOperationsHeaders() != null) {
                if (testResult.getOperationsHeaders().getGlobals() != null) {
                    headers.addAll(testResult.getOperationsHeaders().getGlobals());
                }
                if (testResult.getOperationsHeaders().get((Object)operation.getName()) != null) {
                    headers.addAll((Collection)testResult.getOperationsHeaders().get((Object)operation.getName()));
                }
            }
            if (!headers.isEmpty()) {
                ArrayNode jsonHeaders = this.buildHeaders(headers);
                jsonRequest.set("headers", (JsonNode)jsonHeaders);
            }
            jsonRequests.add((JsonNode)jsonRequest);
        }
        jsonArg.set("requests", (JsonNode)jsonRequests);
        URI postmanRunnerURI = new URI(this.postmanRunnerUrl + "/tests/" + testResult.getId());
        ClientHttpRequest httpRequest = this.clientHttpRequestFactory.createRequest(postmanRunnerURI, HttpMethod.POST);
        httpRequest.getBody().write(this.mapper.writeValueAsBytes((Object)jsonArg));
        httpRequest.getHeaders().add("Content-Type", "application/json");
        try (ClientHttpResponse httpResponse = null;){
            httpResponse = httpRequest.execute();
        }
        return new ArrayList<TestReturn>();
    }

    @Override
    public HttpMethod buildMethod(String method) {
        return null;
    }

    private JsonNode extractOperationTestScript(Operation operation) {
        ArrayList<JsonNode> collectedScripts = new ArrayList<JsonNode>();
        Iterator items = this.collection.path("item").elements();
        while (items.hasNext()) {
            JsonNode item = (JsonNode)items.next();
            this.extractTestScript("", item, operation, collectedScripts);
        }
        if (!collectedScripts.isEmpty()) {
            return (JsonNode)collectedScripts.get(0);
        }
        return null;
    }

    private void extractTestScript(String operationNameRadix, JsonNode itemNode, Operation operation, List<JsonNode> collectedScripts) {
        block3: {
            block2: {
                String itemNodeName = itemNode.path("name").asText();
                if (itemNode.has("request")) break block2;
                Iterator items = itemNode.path("item").elements();
                while (items.hasNext()) {
                    JsonNode item = (JsonNode)items.next();
                    this.extractTestScript(operationNameRadix + "/" + itemNodeName, item, operation, collectedScripts);
                }
                break block3;
            }
            String operationName = PostmanCollectionImporter.buildOperationName(itemNode, operationNameRadix);
            log.debug("Found operation '{}', comparing with '{}'", (Object)operationName, (Object)operation.getName());
            if (!PostmanUtil.areOperationsEquivalent(operation.getName(), operationName)) break block3;
            JsonNode events = itemNode.path("event");
            for (JsonNode event : events) {
                if (!"test".equals(event.path("listen").asText())) continue;
                log.debug("Found a matching event where listen=test");
                collectedScripts.add(event);
            }
        }
    }

    private ArrayNode buildQueryParams(List<Parameter> queryParameters) {
        ArrayNode jsonQPS = this.mapper.createArrayNode();
        for (Parameter parameter : queryParameters) {
            ObjectNode jsonQP = this.mapper.createObjectNode();
            jsonQP.put("key", parameter.getName());
            jsonQP.put("value", parameter.getValue());
            jsonQPS.add((JsonNode)jsonQP);
        }
        return jsonQPS;
    }

    private ArrayNode buildHeaders(Set<Header> headers) {
        ArrayNode jsonHS = this.mapper.createArrayNode();
        for (Header header : headers) {
            ObjectNode jsonH = this.mapper.createObjectNode();
            jsonH.put("key", header.getName());
            jsonH.put("value", this.buildValue(header.getValues()));
            jsonHS.add((JsonNode)jsonH);
        }
        return jsonHS;
    }
}

