/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.github.mngsk.devicedetector.client.Client;
import io.github.mngsk.devicedetector.device.Device;
import io.github.mngsk.devicedetector.operatingsystem.OperatingSystem;
import io.github.mngsk.devicedetector.operatingsystem.VendorFragmentParser;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class Detection {
    private static VendorFragmentParser vendorFragmentParser = new VendorFragmentParser();
    private static Pattern touchEnabledPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Touch)");
    private static Pattern androidTabletPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Android( [\\.0-9]+)?; Tablet;)", 2);
    private static Pattern androidMobilePattern = Pattern.compile("(?:^|[^A-Z_-])(?:Android( [\\.0-9]+)?; Mobile;)", 2);
    private static Pattern chromePattern = Pattern.compile("(?:^|[^A-Z_-])(?:Chrome/[\\.0-9]*)", 2);
    private static Pattern chromeSmartphonePattern = Pattern.compile("(?:^|[^A-Z_-])(?:Chrome/[\\.0-9]* (?:Mobile|eliboM))", 2);
    private static Pattern chromeTabletPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Chrome/[\\.0-9]* (?!Mobile))", 2);
    private static Pattern operaTabletPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Opera Tablet)", 2);
    private static Pattern operaTvPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Opera TV Store)", 2);
    private static List<String> mobileDeviceTypes = Arrays.asList("feature phone", "smartphone", "tablet", "phablet", "camera", "portable media player");
    private static List<String> nonMobileDeviceTypes = Arrays.asList("tv", "smart display", "console");
    private static List<String> mobileOnlyBrowsers = Arrays.asList("360 Phone Browser", "Oculus Browser", "Puffin", "Skyfire", "Mobile Safari", "Opera Mini", "Opera Mobile", "DuckDuckGo Privacy Browser", "dbrowser", "Streamy", "B-Line", "Isivioo", "Firefox Mobile", "Coast", "CoolBrowser", "Sailfish Browser", "Samsung Browser", "Firefox Rocket", "Web Explorer", "Hawk Turbo Browser", "Nox Browser", "Huawei Browser", "vivo Browser", "Realme Browser", "COS Browser", "Meizu Browser", "UC Browser Mini", "Firefox Focus", "Faux Browser", "Wear Internet Browser", "Minimo", "mCent", "Aloha Browser Lite", "Super Fast Browser", "EUI Browser", "eZ Browser", "UC Browser Turbo", "Delta Browser", "START Internet Browser", "Quark", "Yaani Browser", "Japan Browser", "Ghostery Privacy Browser", "PrivacyWall", "Stargon", "Kode Browser", "Perfect Browser", "UC Browser HD", "SP Browser", "Cornowser", "Smooz", "GinxDroid Browser", "Venus Browser", "Arvin");
    private static List<String> desktopOperatingSystems = Arrays.asList("AmigaOS", "IBM", "GNU/Linux", "Mac", "Unix", "Windows", "BeOS", "Chrome OS");
    private static List<String> appleOperatingSystems = Arrays.asList("Apple TV", "iOS", "Mac");
    private static Pattern tvPattern = Pattern.compile("(?:^|[^A-Z_-])(?:SmartTV|Tizen.+ TV .+$)", 2);
    private static List<String> tvBrowsers = Arrays.asList("Kylo", "Espial TV Browser");
    private static Pattern desktopPattern = Pattern.compile("(?:^|[^A-Z_-])(?:Desktop (x(?:32|64)|WOW64);)", 2);
    private static ComparableVersion v2 = new ComparableVersion("2.0");
    private static ComparableVersion v3 = new ComparableVersion("3.0");
    private static ComparableVersion v4 = new ComparableVersion("4.0");
    private static ComparableVersion v8 = new ComparableVersion("8");
    private final String userAgent;
    private final Device device;
    private final OperatingSystem operatingSystem;
    private final Client client;

    public Detection(String userAgent, Device device, OperatingSystem operatingSystem, Client client) {
        this.userAgent = userAgent;
        this.operatingSystem = operatingSystem;
        this.client = client;
        this.device = this.fillDevice(device);
    }

    private Device fillDevice(Device device) {
        String type = null;
        String brand = null;
        String model = null;
        if (device != null) {
            type = device.getType();
            brand = device.getBrand().orElse(null);
            model = device.getModel().orElse(null);
        }
        if (brand == null) {
            brand = vendorFragmentParser.parse(this.userAgent).orElse(null);
        }
        if (brand == null && this.operatingSystem != null && appleOperatingSystems.contains(this.operatingSystem.getName())) {
            brand = "Apple";
        }
        if (type == null && this.operatingSystem != null && this.operatingSystem.getFamily().orElse("").equals("Android") && this.client != null && this.client.getType().equals("browser") && chromePattern.matcher(this.userAgent).find()) {
            if (chromeSmartphonePattern.matcher(this.userAgent).find()) {
                type = "smartphone";
            } else if (chromeTabletPattern.matcher(this.userAgent).find()) {
                type = "tablet";
            }
        }
        if (type == null && (androidTabletPattern.matcher(this.userAgent).find() || operaTabletPattern.matcher(this.userAgent).find())) {
            type = "tablet";
        }
        if (type == null && androidMobilePattern.matcher(this.userAgent).find()) {
            type = "smartphone";
        }
        Optional<Object> osVersion = Optional.empty();
        if (this.operatingSystem != null && !this.operatingSystem.getVersion().orElse("").isEmpty()) {
            osVersion = Optional.of(new ComparableVersion(this.operatingSystem.getVersion().get()));
        }
        if (type == null && this.operatingSystem != null && this.operatingSystem.getFamily().orElse("").equals("Android") && osVersion.isPresent()) {
            if (((ComparableVersion)osVersion.get()).compareTo(v2) < 0) {
                type = "smartphone";
            } else if (((ComparableVersion)osVersion.get()).compareTo(v3) >= 0 && ((ComparableVersion)osVersion.get()).compareTo(v4) < 0) {
                type = "tablet";
            }
        }
        if (type != null && type.equals("feature phone") && this.operatingSystem != null && this.operatingSystem.getFamily().orElse("").equals("Android")) {
            type = "smartphone";
        }
        if (type == null && this.operatingSystem != null && (this.operatingSystem.getName().equals("Windows RT") || this.operatingSystem.getName().equals("Windows") && osVersion.isPresent() && ((ComparableVersion)osVersion.get()).compareTo(v8) >= 0) && touchEnabledPattern.matcher(this.userAgent).find()) {
            type = "tablet";
        }
        if (operaTvPattern.matcher(this.userAgent).find()) {
            type = "tv";
        }
        if (type == null && tvPattern.matcher(this.userAgent).find()) {
            type = "tv";
        }
        if (type == null && this.client != null && tvBrowsers.contains(this.client.getName().orElse(""))) {
            type = "tv";
        }
        if (type != "desktop" && this.userAgent.contains("Desktop") && desktopPattern.matcher(this.userAgent).find()) {
            type = "desktop";
        }
        if (type == null && this.isDesktop()) {
            type = "desktop";
        }
        if (type != null) {
            return new Device(type, brand, model);
        }
        return null;
    }

    @JsonIgnore
    public String getUserAgent() {
        return this.userAgent;
    }

    public Optional<Device> getDevice() {
        return Optional.ofNullable(this.device);
    }

    public Optional<OperatingSystem> getOperatingSystem() {
        return Optional.ofNullable(this.operatingSystem);
    }

    public Optional<Client> getClient() {
        return Optional.ofNullable(this.client);
    }

    @JsonIgnore
    public boolean isTouchEnabled() {
        return touchEnabledPattern.matcher(this.userAgent).find();
    }

    @JsonIgnore
    public boolean isSmartphone() {
        return this.device != null ? this.device.getType().equals("smartphone") : false;
    }

    @JsonIgnore
    public boolean isFeaturePhone() {
        return this.device != null ? this.device.getType().equals("feature phone") : false;
    }

    @JsonIgnore
    public boolean isTablet() {
        return this.device != null ? this.device.getType().equals("tablet") : false;
    }

    @JsonIgnore
    public boolean isPhablet() {
        return this.device != null ? this.device.getType().equals("phablet") : false;
    }

    @JsonIgnore
    public boolean isConsole() {
        return this.device != null ? this.device.getType().equals("console") : false;
    }

    @JsonIgnore
    public boolean isPortableMediaPlayer() {
        return this.device != null ? this.device.getType().equals("portable media player") : false;
    }

    @JsonIgnore
    public boolean isCarBrowser() {
        return this.device != null ? this.device.getType().equals("car browser") : false;
    }

    @JsonIgnore
    public boolean isCamera() {
        return this.device != null ? this.device.getType().equals("camera") : false;
    }

    @JsonIgnore
    public boolean isNotebook() {
        return this.device != null ? this.device.getType().equals("notebook") : false;
    }

    @JsonIgnore
    public boolean isTV() {
        return this.device != null ? this.device.getType().equals("tv") : false;
    }

    @JsonIgnore
    public boolean isSmartDisplay() {
        return this.device != null ? this.device.getType().equals("smart display") : false;
    }

    @JsonIgnore
    public boolean isSmartSpeaker() {
        return this.device != null ? this.device.getType().equals("smart speaker") : false;
    }

    @JsonIgnore
    public boolean usesMobileBrowser() {
        return this.client != null && this.client.getType().equals("browser") && mobileOnlyBrowsers.contains(this.client.getName().orElse(""));
    }

    @JsonIgnore
    public boolean isMobile() {
        if (this.device != null && mobileDeviceTypes.contains(this.device.getType())) {
            return true;
        }
        if (this.device != null && nonMobileDeviceTypes.contains(this.device.getType())) {
            return false;
        }
        if (this.usesMobileBrowser()) {
            return true;
        }
        if (this.operatingSystem == null) {
            return false;
        }
        return !this.isBot() && !this.isDesktop();
    }

    @JsonIgnore
    public boolean isDesktop() {
        if (this.operatingSystem == null) {
            return false;
        }
        if (this.usesMobileBrowser()) {
            return false;
        }
        return desktopOperatingSystems.contains(this.operatingSystem.getFamily().orElse(""));
    }

    @JsonIgnore
    public boolean isBot() {
        return this.client != null ? this.client.getType().equals("bot") : false;
    }

    @JsonIgnore
    public boolean isBrowser() {
        return this.client != null ? this.client.getType().equals("browser") : false;
    }

    @JsonIgnore
    public boolean isFeedReader() {
        return this.client != null ? this.client.getType().equals("feed reader") : false;
    }

    @JsonIgnore
    public boolean isMobileApp() {
        return this.client != null ? this.client.getType().equals("mobile app") : false;
    }

    @JsonIgnore
    public boolean isPIM() {
        return this.client != null ? this.client.getType().equals("pim") : false;
    }

    @JsonIgnore
    public boolean isLibrary() {
        return this.client != null ? this.client.getType().equals("library") : false;
    }

    @JsonIgnore
    public boolean isMediaPlayer() {
        return this.client != null ? this.client.getType().equals("mediaplayer") : false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.device != null) {
            builder.append(this.device);
        }
        if (this.operatingSystem != null) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this.operatingSystem);
        }
        if (this.client != null) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append(this.client);
        }
        if (builder.length() == 0) {
            builder.append("unknown");
        }
        return builder.toString();
    }
}

