/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.client;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.mngsk.devicedetector.client.Client;
import io.github.mngsk.devicedetector.client.ClientRegex;
import io.github.mngsk.devicedetector.util.AbstractParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;

public abstract class AbstractClientParser<T extends ClientRegex>
extends AbstractParser<Client> {
    protected String type;
    protected List<T> regexes;

    public AbstractClientParser(String type, String fixtureFile) {
        this(type, fixtureFile, new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public AbstractClientParser(String type, String fixtureFile, ObjectMapper objectMapper) {
        this.type = type;
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        Class regexClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        CollectionType listType = objectMapper.getTypeFactory().constructCollectionType(List.class, regexClass);
        try {
            this.regexes = (List)objectMapper.readValue(inputStream, (JavaType)listType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
    }

    @Override
    public Optional<Client> parse(String userAgent) {
        for (ClientRegex regex : this.regexes) {
            Matcher matcher = regex.getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            String name = super.buildByMatch(regex.getName(), matcher);
            String version = super.buildVersion(regex.getVersion(), matcher);
            return Optional.of(new Client(this.type, name, version));
        }
        return Optional.empty();
    }
}

