/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.device;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.mngsk.devicedetector.device.Device;
import io.github.mngsk.devicedetector.device.DeviceRegex;
import io.github.mngsk.devicedetector.device.ModelRegex;
import io.github.mngsk.devicedetector.util.AbstractParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;

public class AbstractDeviceParser
extends AbstractParser<Device> {
    private Map<String, DeviceRegex> devices;

    public AbstractDeviceParser(String fixtureFile) {
        this(fixtureFile, new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public AbstractDeviceParser(String fixtureFile, ObjectMapper objectMapper) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, DeviceRegex.class);
        try {
            this.devices = (Map)objectMapper.readValue(inputStream, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
    }

    @Override
    public Optional<Device> parse(String userAgent) {
        for (Map.Entry<String, DeviceRegex> device : this.devices.entrySet()) {
            Matcher matcher = device.getValue().getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            Optional<Device> result = this.parseDevice(device, userAgent);
            if (result.isPresent()) {
                return result;
            }
            String type = device.getValue().getDevice();
            String brand = device.getKey();
            if (brand.equalsIgnoreCase("unknown")) {
                brand = null;
            }
            String model = this.buildModel(device.getValue().getModel().orElse(null), matcher);
            return Optional.of(new Device(type, brand, model));
        }
        return Optional.empty();
    }

    private Optional<Device> parseDevice(Map.Entry<String, DeviceRegex> device, String userAgent) {
        if (device.getValue().getModels() == null || device.getValue().getModels().isEmpty()) {
            return Optional.empty();
        }
        for (ModelRegex regex : device.getValue().getModels()) {
            Matcher matcher = regex.getPattern().matcher(userAgent);
            if (!matcher.find()) continue;
            String type = regex.getDevice().orElse(device.getValue().getDevice());
            String brand = regex.getBrand().orElse(device.getKey());
            if (brand.equalsIgnoreCase("unknown")) {
                brand = null;
            }
            String model = this.buildModel(regex.getModel(), matcher);
            return Optional.of(new Device(type, brand, model));
        }
        return Optional.empty();
    }

    private String buildModel(String model, Matcher matcher) {
        if ((model = super.buildByMatch(model, matcher)) == null) {
            return null;
        }
        model = model.replace("_", " ");
        if ((model = model.replaceAll("\\sTD$", "")).equals("Build")) {
            return null;
        }
        return model.trim().isEmpty() ? null : model.trim();
    }
}

