/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.operatingsystem;

import java.util.Optional;

public class OperatingSystem {
    private final String name;
    private final String family;
    private final String platform;
    private final String version;

    public OperatingSystem(String name, String family, String platform, String version) {
        this.name = name;
        this.family = family;
        this.platform = platform;
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public Optional<String> getFamily() {
        return Optional.ofNullable(this.family);
    }

    public Optional<String> getPlatform() {
        return Optional.ofNullable(this.platform);
    }

    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OperatingSystem other = (OperatingSystem)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        if (this.getVersion().isPresent()) {
            builder.append(" ").append(this.version);
        }
        if (this.getPlatform().isPresent()) {
            builder.append(" (").append(this.platform).append(")");
        }
        return builder.toString();
    }
}

