/*
 * Decompiled with CFR 0.152.
 */
package io.github.mngsk.devicedetector.operatingsystem;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.github.mngsk.devicedetector.util.AbstractParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VendorFragmentParser
extends AbstractParser<String> {
    private Map<String, String[]> brands;

    public VendorFragmentParser() {
        this(new ObjectMapper((JsonFactory)new YAMLFactory()));
    }

    public VendorFragmentParser(ObjectMapper objectMapper) {
        String fixtureFile = "regexes/vendorfragments.yml";
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(fixtureFile);
        MapType mapType = objectMapper.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, String[].class);
        try {
            this.brands = (Map)objectMapper.readValue(inputStream, (JavaType)mapType);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + fixtureFile, e);
        }
    }

    @Override
    public Optional<String> parse(String userAgent) {
        for (Map.Entry<String, String[]> brand : this.brands.entrySet()) {
            for (String regex : brand.getValue()) {
                Matcher matcher = Pattern.compile(regex + "[^a-z0-9]+", 2).matcher(userAgent);
                if (!matcher.find()) continue;
                return Optional.of(brand.getKey());
            }
        }
        return Optional.empty();
    }
}

