/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.service.impl;

import com.mzt.logapi.context.LogRecordContext;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import com.mzt.logapi.util.diff.ArrayDiffer;
import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.comparison.ComparisonService;
import de.danielbechler.diff.comparison.ComparisonStrategyResolver;
import de.danielbechler.diff.identity.IdentityStrategyResolver;
import de.danielbechler.diff.node.DiffNode;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.AopUtils;

public class DiffParseFunction {
    private static final Logger log = LoggerFactory.getLogger(DiffParseFunction.class);
    public static final String diffFunctionName = "_DIFF";
    public static final String OLD_OBJECT = "_oldObj";
    private IDiffItemsToLogContentService diffItemsToLogContentService;
    private final Set<Class<?>> comparisonSet = new HashSet();

    public String functionName() {
        return diffFunctionName;
    }

    public String diff(Object source, Object target) {
        if (source == null && target == null) {
            return "";
        }
        if (source == null || target == null) {
            try {
                Class<?> clazz = source == null ? target.getClass() : source.getClass();
                source = source == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : source;
                target = target == null ? clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : target;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (!Objects.equals(AopUtils.getTargetClass(source.getClass()), AopUtils.getTargetClass(target.getClass()))) {
            log.error("diff\u7684\u4e24\u4e2a\u5bf9\u8c61\u7c7b\u578b\u4e0d\u540c, source.class={}, target.class={}", (Object)source.getClass().toString(), (Object)target.getClass().toString());
            return "";
        }
        ObjectDifferBuilder objectDifferBuilder = ObjectDifferBuilder.startBuilding();
        ObjectDifferBuilder register = objectDifferBuilder.differs().register((differDispatcher, nodeQueryService) -> new ArrayDiffer(differDispatcher, (ComparisonStrategyResolver)((ComparisonService)objectDifferBuilder.comparison()), (IdentityStrategyResolver)objectDifferBuilder.identity()));
        for (Class<?> clazz : this.comparisonSet) {
            register.comparison().ofType(clazz).toUseEqualsMethod();
        }
        DiffNode diffNode = register.build().compare(target, source);
        return this.diffItemsToLogContentService.toLogContent(diffNode, source, target);
    }

    public String diff(Object newObj) {
        Object oldObj = LogRecordContext.getMethodOrGlobal(OLD_OBJECT);
        return this.diff(oldObj, newObj);
    }

    public void setDiffItemsToLogContentService(IDiffItemsToLogContentService diffItemsToLogContentService) {
        this.diffItemsToLogContentService = diffItemsToLogContentService;
    }

    public void addUseEqualsClass(List<String> classList) {
        if (classList != null && !classList.isEmpty()) {
            for (String clazz : classList) {
                try {
                    Class<?> aClass = Class.forName(clazz);
                    this.comparisonSet.add(aClass);
                }
                catch (ClassNotFoundException e) {
                    log.warn("\u65e0\u6548\u7684\u6bd4\u5bf9\u7c7b\u578b, className={}", (Object)clazz);
                }
            }
        }
    }

    public void addUseEqualsClass(Class clazz) {
        this.comparisonSet.add(clazz);
    }
}

