/*
 * Decompiled with CFR 0.152.
 */
package feign.jaxb;

import feign.jaxb.JAXBContextCacheKey;
import feign.jaxb.JAXBContextInstantationMode;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.ValidationEventHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.validation.Schema;

public final class JAXBContextFactory {
    private final ConcurrentHashMap<JAXBContextCacheKey, JAXBContext> jaxbContexts = new ConcurrentHashMap(64);
    private final Map<String, Object> properties;
    private final JAXBContextInstantationMode jaxbContextInstantationMode;
    private final ValidationEventHandler marshallerEventHandler;
    private final ValidationEventHandler unmarshallerEventHandler;
    private final Schema marshallerSchema;
    private final Schema unmashallerSchema;

    private JAXBContextFactory(Map<String, Object> properties, JAXBContextInstantationMode jaxbContextInstantationMode, ValidationEventHandler marshallerEventHandler, ValidationEventHandler unmarshallerEventHandler, Schema marshallerSchema, Schema unmashallerSchema) {
        this.properties = properties;
        this.jaxbContextInstantationMode = jaxbContextInstantationMode;
        this.marshallerEventHandler = marshallerEventHandler;
        this.unmarshallerEventHandler = unmarshallerEventHandler;
        this.marshallerSchema = marshallerSchema;
        this.unmashallerSchema = unmashallerSchema;
    }

    @Deprecated
    private JAXBContextFactory(Map<String, Object> properties, JAXBContextInstantationMode jaxbContextInstantationMode) {
        this(properties, jaxbContextInstantationMode, null, null, null, null);
    }

    public Unmarshaller createUnmarshaller(Class<?> clazz) throws JAXBException {
        Unmarshaller unmarshaller = this.getContext(clazz).createUnmarshaller();
        if (this.unmarshallerEventHandler != null) {
            unmarshaller.setEventHandler(this.unmarshallerEventHandler);
        }
        unmarshaller.setSchema(this.unmashallerSchema);
        return unmarshaller;
    }

    public Marshaller createMarshaller(Class<?> clazz) throws JAXBException {
        Marshaller marshaller = this.getContext(clazz).createMarshaller();
        this.setMarshallerProperties(marshaller);
        if (this.marshallerEventHandler != null) {
            marshaller.setEventHandler(this.marshallerEventHandler);
        }
        marshaller.setSchema(this.marshallerSchema);
        return marshaller;
    }

    private void setMarshallerProperties(Marshaller marshaller) throws PropertyException {
        for (Map.Entry<String, Object> en : this.properties.entrySet()) {
            marshaller.setProperty(en.getKey(), en.getValue());
        }
    }

    private JAXBContext getContext(Class<?> clazz) throws JAXBException {
        JAXBContextCacheKey cacheKey = this.jaxbContextInstantationMode.getJAXBContextCacheKey(clazz);
        JAXBContext jaxbContext = this.jaxbContexts.get(cacheKey);
        if (jaxbContext == null) {
            jaxbContext = this.jaxbContextInstantationMode.getJAXBContext(clazz);
            this.jaxbContexts.putIfAbsent(cacheKey, jaxbContext);
        }
        return jaxbContext;
    }

    private void preloadContextCache(List<Class<?>> classes) throws JAXBException {
        if (classes != null && !classes.isEmpty()) {
            for (Class<?> clazz : classes) {
                this.getContext(clazz);
            }
        }
    }

    public static class Builder {
        private final Map<String, Object> properties = new HashMap<String, Object>(10);
        private JAXBContextInstantationMode jaxbContextInstantationMode = JAXBContextInstantationMode.CLASS;
        private ValidationEventHandler marshallerEventHandler;
        private ValidationEventHandler unmarshallerEventHandler;
        private Schema marshallerSchema;
        private Schema unmarshallerSchema;

        public Builder withMarshallerJAXBEncoding(String value) {
            this.properties.put("jaxb.encoding", value);
            return this;
        }

        public Builder withMarshallerSchemaLocation(String value) {
            this.properties.put("jaxb.schemaLocation", value);
            return this;
        }

        public Builder withMarshallerNoNamespaceSchemaLocation(String value) {
            this.properties.put("jaxb.noNamespaceSchemaLocation", value);
            return this;
        }

        public Builder withMarshallerFormattedOutput(Boolean value) {
            this.properties.put("jaxb.formatted.output", value);
            return this;
        }

        public Builder withMarshallerFragment(Boolean value) {
            this.properties.put("jaxb.fragment", value);
            return this;
        }

        public Builder withProperty(String key, Object value) {
            this.properties.put(key, value);
            return this;
        }

        public Builder withMarshallerEventHandler(ValidationEventHandler handler) {
            this.marshallerEventHandler = handler;
            return this;
        }

        public Builder withUnmarshallerEventHandler(ValidationEventHandler handler) {
            this.unmarshallerEventHandler = handler;
            return this;
        }

        public Builder withMarshallerSchema(Schema schema) {
            this.marshallerSchema = schema;
            return this;
        }

        public Builder withUnmarshallerSchema(Schema schema) {
            this.unmarshallerSchema = schema;
            return this;
        }

        public Builder withJAXBContextInstantiationMode(JAXBContextInstantationMode jaxbContextInstantiationMode) {
            this.jaxbContextInstantationMode = jaxbContextInstantiationMode;
            return this;
        }

        public JAXBContextFactory build() {
            return new JAXBContextFactory(this.properties, this.jaxbContextInstantationMode, this.marshallerEventHandler, this.unmarshallerEventHandler, this.marshallerSchema, this.unmarshallerSchema);
        }

        public JAXBContextFactory build(List<Class<?>> classes) throws JAXBException {
            JAXBContextFactory factory = this.build();
            factory.preloadContextCache(classes);
            return factory;
        }
    }
}

