/*
 * Decompiled with CFR 0.152.
 */
package feign.ribbon;

import com.netflix.client.AbstractLoadBalancerAwareClient;
import com.netflix.client.ClientException;
import com.netflix.client.ClientRequest;
import com.netflix.client.IResponse;
import com.netflix.client.RequestSpecificRetryHandler;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.ILoadBalancer;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.ribbon.LBClientFactory;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public final class LBClient
extends AbstractLoadBalancerAwareClient<RibbonRequest, RibbonResponse> {
    private final int connectTimeout;
    private final int readTimeout;
    private final IClientConfig clientConfig;
    private final Set<Integer> retryableStatusCodes;
    private final Boolean followRedirects;

    public static LBClient create(ILoadBalancer lb, IClientConfig clientConfig) {
        return new LBClient(lb, clientConfig);
    }

    static Set<Integer> parseStatusCodes(String statusCodesString) {
        if (statusCodesString == null || statusCodesString.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<Integer> codes = new LinkedHashSet<Integer>();
        for (String codeString : statusCodesString.split(",")) {
            codes.add(Integer.parseInt(codeString));
        }
        return codes;
    }

    LBClient(ILoadBalancer lb, IClientConfig clientConfig) {
        super(lb, clientConfig);
        this.clientConfig = clientConfig;
        this.connectTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ConnectTimeout);
        this.readTimeout = (Integer)clientConfig.get(CommonClientConfigKey.ReadTimeout);
        this.retryableStatusCodes = LBClient.parseStatusCodes((String)clientConfig.get(LBClientFactory.RetryableStatusCodes));
        this.followRedirects = (Boolean)clientConfig.get(CommonClientConfigKey.FollowRedirects);
    }

    public RibbonResponse execute(RibbonRequest request, IClientConfig configOverride) throws IOException, ClientException {
        Request.Options options = configOverride != null ? new Request.Options((long)((Integer)configOverride.get(CommonClientConfigKey.ConnectTimeout, (Object)this.connectTimeout)).intValue(), TimeUnit.MILLISECONDS, (long)((Integer)configOverride.get(CommonClientConfigKey.ReadTimeout, (Object)this.readTimeout)).intValue(), TimeUnit.MILLISECONDS, ((Boolean)configOverride.get(CommonClientConfigKey.FollowRedirects, (Object)this.followRedirects)).booleanValue()) : new Request.Options((long)this.connectTimeout, TimeUnit.MILLISECONDS, (long)this.readTimeout, TimeUnit.MILLISECONDS, true);
        Response response = request.client().execute(request.toRequest(), options);
        if (this.retryableStatusCodes.contains(response.status())) {
            response.close();
            throw new ClientException(ClientException.ErrorType.SERVER_THROTTLED);
        }
        return new RibbonResponse(request.getUri(), response);
    }

    public RequestSpecificRetryHandler getRequestSpecificRetryHandler(RibbonRequest request, IClientConfig requestConfig) {
        if (((Boolean)this.clientConfig.get(CommonClientConfigKey.OkToRetryOnAllOperations, (Object)false)).booleanValue()) {
            return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
        }
        if (request.toRequest().httpMethod() != Request.HttpMethod.GET) {
            return new RequestSpecificRetryHandler(true, false, this.getRetryHandler(), requestConfig);
        }
        return new RequestSpecificRetryHandler(true, true, this.getRetryHandler(), requestConfig);
    }

    static class RibbonResponse
    implements IResponse {
        private final URI uri;
        private final Response response;

        RibbonResponse(URI uri, Response response) {
            this.uri = uri;
            this.response = response;
        }

        public Object getPayload() throws ClientException {
            return this.response.body();
        }

        public boolean hasPayload() {
            return this.response.body() != null;
        }

        public boolean isSuccess() {
            return this.response.status() == 200;
        }

        public URI getRequestedURI() {
            return this.uri;
        }

        public Map<String, Collection<String>> getHeaders() {
            return this.response.headers();
        }

        Response toResponse() {
            return this.response;
        }

        public void close() throws IOException {
            if (this.response != null && this.response.body() != null) {
                this.response.body().close();
            }
        }
    }

    static class RibbonRequest
    extends ClientRequest
    implements Cloneable {
        private final Request request;
        private final Client client;

        RibbonRequest(Client client, Request request, URI uri) {
            this.client = client;
            this.request = request;
            this.setUri(uri);
        }

        Request toRequest() {
            byte[] body = this.request.body();
            int bodyLength = body != null ? body.length : 0;
            LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
            headers.putAll(this.request.headers());
            headers.put("Content-Length", Collections.singletonList(String.valueOf(bodyLength)));
            return Request.create((Request.HttpMethod)this.request.httpMethod(), (String)this.getUri().toASCIIString(), headers, (byte[])body, (Charset)this.request.charset());
        }

        Client client() {
            return this.client;
        }

        public Object clone() {
            return new RibbonRequest(this.client, this.request, this.getUri());
        }
    }
}

