/*
 * Decompiled with CFR 0.152.
 */
package feign.sax;

import feign.Response;
import feign.Util;
import feign.codec.DecodeException;
import feign.codec.Decoder;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class SAXDecoder
implements Decoder {
    private final Map<Type, ContentHandlerWithResult.Factory<?>> handlerFactories;

    private SAXDecoder(Map<Type, ContentHandlerWithResult.Factory<?>> handlerFactories) {
        this.handlerFactories = handlerFactories;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Response response, Type type) throws IOException, DecodeException {
        if (response.status() == 404) {
            return Util.emptyValueOf((Type)type);
        }
        if (response.body() == null) {
            return null;
        }
        ContentHandlerWithResult.Factory<?> handlerFactory = this.handlerFactories.get(type);
        Util.checkState((handlerFactory != null ? 1 : 0) != 0, (String)"type %s not in configured handlers %s", (Object[])new Object[]{type, this.handlerFactories.keySet()});
        ContentHandlerWithResult<?> handler = handlerFactory.create();
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", false);
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", false);
            xmlReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xmlReader.setContentHandler(handler);
            InputStream inputStream = response.body().asInputStream();
            try {
                xmlReader.parse(new InputSource(inputStream));
            }
            finally {
                Util.ensureClosed((Closeable)inputStream);
            }
            return handler.result();
        }
        catch (SAXException e) {
            throw new DecodeException(e.getMessage(), (Throwable)e);
        }
    }

    public static class Builder {
        private final Map<Type, ContentHandlerWithResult.Factory<?>> handlerFactories = new LinkedHashMap();

        public <T extends ContentHandlerWithResult<?>> Builder registerContentHandler(Class<T> handlerClass) {
            Type type = Util.resolveLastTypeParameter((Type)((Type)Util.checkNotNull(handlerClass, (String)"handlerClass", (Object[])new Object[0])), ContentHandlerWithResult.class);
            return this.registerContentHandler(type, new NewInstanceContentHandlerWithResultFactory(handlerClass));
        }

        public Builder registerContentHandler(Type type, ContentHandlerWithResult.Factory<?> handler) {
            this.handlerFactories.put((Type)Util.checkNotNull((Object)type, (String)"type", (Object[])new Object[0]), (ContentHandlerWithResult.Factory)Util.checkNotNull(handler, (String)"handler", (Object[])new Object[0]));
            return this;
        }

        public SAXDecoder build() {
            return new SAXDecoder(this.handlerFactories);
        }

        private static class NewInstanceContentHandlerWithResultFactory<T>
        implements ContentHandlerWithResult.Factory<T> {
            private final Constructor<ContentHandlerWithResult<T>> ctor;

            private NewInstanceContentHandlerWithResultFactory(Class<ContentHandlerWithResult<T>> clazz) {
                try {
                    this.ctor = clazz.getDeclaredConstructor(new Class[0]);
                    this.ctor.setAccessible(true);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("ensure " + clazz + " has a no-args constructor", e);
                }
            }

            @Override
            public ContentHandlerWithResult<T> create() {
                try {
                    return this.ctor.newInstance(new Object[0]);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("exception attempting to instantiate " + this.ctor, e);
                }
            }
        }
    }

    public static interface ContentHandlerWithResult<T>
    extends ContentHandler {
        public T result();

        public static interface Factory<T> {
            public ContentHandlerWithResult<T> create();
        }
    }
}

