/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.codegen;

import com.querydsl.codegen.QueryTypeFactory;
import com.querydsl.codegen.utils.model.SimpleType;
import com.querydsl.codegen.utils.model.Type;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class QueryTypeFactoryImpl
implements QueryTypeFactory {
    private final String prefix;
    private final String suffix;
    private final String packageSuffix;

    @Inject
    public QueryTypeFactoryImpl(@Named(value="prefix") String prefix, @Named(value="suffix") String suffix, @Named(value="packageSuffix") String packageSuffix) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.packageSuffix = packageSuffix;
    }

    @Override
    public Type create(Type type) {
        if (type.getPackageName().isEmpty()) {
            return this.createWithoutPackage(type);
        }
        return this.createWithPackage(type);
    }

    private Type createWithPackage(Type type) {
        Object packageName = type.getPackageName();
        String simpleName = this.prefix + this.normalizeName(type.getFullName().substring(((String)packageName).length() + 1)) + this.suffix;
        packageName = (((String)packageName).startsWith("java") ? "ext." : "") + (String)packageName + this.packageSuffix;
        return new SimpleType(type.getCategory(), (String)packageName + "." + simpleName, (String)packageName, simpleName, false, false, new Type[0]);
    }

    private Type createWithoutPackage(Type type) {
        String simpleName = this.prefix + this.normalizeName(type.getFullName()) + this.suffix;
        return new SimpleType(type.getCategory(), simpleName, "", simpleName, false, false, new Type[0]);
    }

    private String normalizeName(String name) {
        return name.replace('.', '_').replace('$', '_');
    }
}

