/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.builder.document;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.builder.document.MarkupDocument;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OverviewDocument
extends MarkupDocument {
    private static final String OVERVIEW = "Overview";
    private static final String CURRENT_VERSION = "Version information";
    private static final String VERSION = "Version: ";
    private static final String CONTACT_INFORMATION = "Contact information";
    private static final String CONTACT_NAME = "Contact: ";
    private static final String CONTACT_EMAIL = "Contact Email: ";
    private static final String LICENSE_INFORMATION = "License information";
    private static final String LICENSE = "License: ";
    private static final String LICENSE_URL = "License URL: ";
    private static final String TERMS_OF_SERVICE = "Terms of service: ";
    private static final String URI_SCHEME = "URI scheme";
    private static final String HOST = "Host: ";
    private static final String BASE_PATH = "BasePath: ";
    private static final String SCHEMES = "Schemes: ";

    public OverviewDocument(Swagger swagger, MarkupLanguage markupLanguage) {
        super(swagger, markupLanguage);
    }

    @Override
    public MarkupDocument build() throws IOException {
        this.overview();
        return this;
    }

    private void overview() {
        License license;
        Contact contact;
        Info info = this.swagger.getInfo();
        this.markupDocBuilder.documentTitle(info.getTitle());
        this.markupDocBuilder.sectionTitleLevel1(OVERVIEW);
        if (StringUtils.isNotBlank((CharSequence)info.getDescription())) {
            this.markupDocBuilder.textLine(info.getDescription());
            this.markupDocBuilder.newLine();
        }
        if (StringUtils.isNotBlank((CharSequence)info.getVersion())) {
            this.markupDocBuilder.sectionTitleLevel2(CURRENT_VERSION);
            this.markupDocBuilder.textLine(VERSION + info.getVersion());
            this.markupDocBuilder.newLine();
        }
        if ((contact = info.getContact()) != null) {
            this.markupDocBuilder.sectionTitleLevel2(CONTACT_INFORMATION);
            if (StringUtils.isNotBlank((CharSequence)contact.getName())) {
                this.markupDocBuilder.textLine(CONTACT_NAME + contact.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)contact.getEmail())) {
                this.markupDocBuilder.textLine(CONTACT_EMAIL + contact.getEmail());
            }
            this.markupDocBuilder.newLine();
        }
        if ((license = info.getLicense()) != null && (StringUtils.isNotBlank((CharSequence)license.getName()) || StringUtils.isNotBlank((CharSequence)license.getUrl()))) {
            this.markupDocBuilder.sectionTitleLevel2(LICENSE_INFORMATION);
            if (StringUtils.isNotBlank((CharSequence)license.getName())) {
                this.markupDocBuilder.textLine(LICENSE + license.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)license.getUrl())) {
                this.markupDocBuilder.textLine(LICENSE_URL + license.getUrl());
            }
            this.markupDocBuilder.newLine();
        }
        if (StringUtils.isNotBlank((CharSequence)info.getTermsOfService())) {
            this.markupDocBuilder.textLine(TERMS_OF_SERVICE + info.getTermsOfService());
            this.markupDocBuilder.newLine();
        }
        this.markupDocBuilder.sectionTitleLevel2(URI_SCHEME);
        if (StringUtils.isNotBlank((CharSequence)this.swagger.getHost())) {
            this.markupDocBuilder.textLine(HOST + this.swagger.getHost());
        }
        if (StringUtils.isNotBlank((CharSequence)this.swagger.getBasePath())) {
            this.markupDocBuilder.textLine(BASE_PATH + this.swagger.getBasePath());
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getSchemes())) {
            ArrayList<String> schemes = new ArrayList<String>();
            for (Scheme scheme : this.swagger.getSchemes()) {
                schemes.add(scheme.toString());
            }
            this.markupDocBuilder.textLine(SCHEMES + StringUtils.join(schemes, (String)", "));
        }
        this.markupDocBuilder.newLine();
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getTags())) {
            this.markupDocBuilder.sectionTitleLevel2("Tags");
            ArrayList<String> tags = new ArrayList<String>();
            for (Tag tag : this.swagger.getTags()) {
                String name = tag.getName();
                String description = tag.getDescription();
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{description})) {
                    tags.add(name + ": " + description);
                }
                tags.add(name);
            }
            this.markupDocBuilder.unorderedList(tags);
            this.markupDocBuilder.newLine();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getConsumes())) {
            this.markupDocBuilder.sectionTitleLevel2("Consumes");
            this.markupDocBuilder.unorderedList(this.swagger.getConsumes());
            this.markupDocBuilder.newLine();
        }
        if (CollectionUtils.isNotEmpty((Collection)this.swagger.getProduces())) {
            this.markupDocBuilder.sectionTitleLevel2("Produces");
            this.markupDocBuilder.unorderedList(this.swagger.getProduces());
            this.markupDocBuilder.newLine();
        }
    }
}

