/*
 * Decompiled with CFR 0.152.
 */
package io.github.robwin.swagger2markup.utils;

import io.github.robwin.markup.builder.MarkupLanguage;
import io.github.robwin.swagger2markup.utils.PropertyUtils;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.RefModel;
import org.apache.commons.lang3.Validate;

public final class ModelUtils {
    public static String getType(Model model, MarkupLanguage markupLanguage) {
        Validate.notNull((Object)model, (String)"model must not be null!", (Object[])new Object[0]);
        if (model instanceof ModelImpl) {
            return ((ModelImpl)model).getType();
        }
        if (model instanceof RefModel) {
            switch (markupLanguage) {
                case ASCIIDOC: {
                    return "<<" + ((RefModel)model).getSimpleRef() + ">>";
                }
            }
            return ((RefModel)model).getSimpleRef();
        }
        if (model instanceof ArrayModel) {
            ArrayModel arrayModel = (ArrayModel)model;
            return PropertyUtils.getType(arrayModel.getItems(), markupLanguage) + " " + arrayModel.getType();
        }
        return "NOT FOUND";
    }
}

