/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.model.EnumDictionary;
import com.power.common.util.ClassUtil;
import com.power.common.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EnumUtil {
    public static <T extends EnumDictionary> List<T> getEnumInformation(Class<?> clazz, String codeField, String descField) {
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Enum class can't be null.");
        }
        if (!clazz.isEnum()) {
            throw new RuntimeException(clazz.getCanonicalName() + " is not an enum class.");
        }
        if (StringUtil.isEmpty(codeField) || StringUtil.isEmpty(descField)) {
            throw new RuntimeException(clazz.getCanonicalName() + ":Please specify the code field name of the dictionary enumeration class and the field name that describes the dictionary code information");
        }
        Class<?> enumClass = clazz;
        Enum[] objects = (Enum[])enumClass.getEnumConstants();
        String valueMethodName = codeField.endsWith("()") ? codeField.replace("()", "") : "get" + StringUtil.firstToUpperCase(codeField);
        String descMethodName = descField.endsWith("()") ? descField.replace("()", "") : "get" + StringUtil.firstToUpperCase(descField);
        ArrayList<EnumDictionary> enumDictionaryList = new ArrayList<EnumDictionary>();
        try {
            Method valueMethod = clazz.getDeclaredMethod(valueMethodName, new Class[0]);
            valueMethod.setAccessible(true);
            Method descMethod = clazz.getDeclaredMethod(descMethodName, new Class[0]);
            descMethod.setAccessible(true);
            for (Enum enumType : objects) {
                Object val = valueMethod.invoke((Object)enumType, new Object[0]);
                Object desc = descMethod.invoke((Object)enumType, new Object[0]);
                EnumDictionary dataDict = new EnumDictionary();
                String type = ClassUtil.getSimpleTypeName(val);
                dataDict.setType(type);
                dataDict.setDesc(String.valueOf(desc));
                dataDict.setValue(String.valueOf(val));
                String name = enumType.name();
                int ordinal = enumType.ordinal();
                dataDict.setName(name);
                dataDict.setOrdinal(ordinal);
                enumDictionaryList.add(dataDict);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return enumDictionaryList;
    }

    public static Map<String, List<Map<String, Object>>> getEnumInformation(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Enum class can't be null.");
        }
        if (!clazz.isEnum()) {
            throw new RuntimeException("It's not an enum class.");
        }
        HashMap<String, List<Map<String, Object>>> enumTypeMap = new HashMap<String, List<Map<String, Object>>>();
        Class<Enum<?>> enumClass = clazz;
        ArrayList list = new ArrayList();
        String clazzName = enumClass.getName();
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        Map<String, Method> methods = EnumUtil.getMethods(enumClass, enumConstants);
        for (Enum enumType : enumConstants) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (String key : methods.keySet()) {
                try {
                    Method method = methods.get(key);
                    Object invoke = method.invoke((Object)enumType, new Object[0]);
                    map.put(key, invoke);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            String name = enumType.name();
            int ordinal = enumType.ordinal();
            map.put("name", name);
            map.put("ordinal", ordinal);
            list.add(map);
        }
        enumTypeMap.put(clazzName, list);
        return enumTypeMap;
    }

    public static List<String> getNames(Class<? extends Enum<?>> enumClass) {
        if (Objects.isNull(enumClass)) {
            throw new RuntimeException("Enum class can't be null.");
        }
        Enum<?>[] enumConstants = enumClass.getEnumConstants();
        if (Objects.isNull(enumConstants)) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>(enumConstants.length);
        for (Enum<?> e : enumConstants) {
            list.add(e.name());
        }
        return list;
    }

    public static Object getFieldValueByMethod(Class<?> clazz, String getMethodName) {
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Enum class can't be null.");
        }
        Class<?> enumClass = clazz;
        Enum[] objects = (Enum[])enumClass.getEnumConstants();
        try {
            Method method = clazz.getDeclaredMethod(getMethodName, new Class[0]);
            method.setAccessible(true);
            Enum[] enumArray = objects;
            int n = enumArray.length;
            int n2 = 0;
            if (n2 < n) {
                Enum enumType = enumArray[n2];
                return method.invoke((Object)enumType, new Object[0]);
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Object getFieldValue(Class<?> clazz, String fieldName) {
        if (Objects.isNull(clazz)) {
            throw new RuntimeException("Enum class can't be null.");
        }
        Class<?> enumClass = clazz;
        try {
            Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
            if (enumConstants.length > 0) {
                Field declaredField = enumClass.getDeclaredField(fieldName);
                declaredField.setAccessible(true);
                return declaredField.get(enumConstants[0]);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
            String methodName = "get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1);
            return EnumUtil.getFieldValueByMethod(clazz, methodName);
        }
        return null;
    }

    private static Map<String, Method> getMethods(Class<Enum<?>> enumClass, Enum<?>[] enumConstants) {
        Field[] declaredFields;
        ArrayList<String> enumNames = new ArrayList<String>();
        HashMap<String, Method> methods = new HashMap<String, Method>();
        for (Enum<?> enumType : enumConstants) {
            enumNames.add(enumType.name());
        }
        for (Field field : declaredFields = enumClass.getDeclaredFields()) {
            String fieldName = field.getName();
            if (enumNames.contains(fieldName) || fieldName.equals("$VALUES")) continue;
            try {
                Method method = enumClass.getMethod("get" + (fieldName.charAt(0) + "").toUpperCase() + fieldName.substring(1), new Class[0]);
                methods.put(fieldName, method);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        }
        return methods;
    }
}

