/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth;

import io.hawt.system.AuthenticateResult;
import io.hawt.system.Authenticator;
import io.hawt.web.ForbiddenReason;
import io.hawt.web.ServletHelpers;
import io.hawt.web.auth.AuthSessionHelpers;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.RelativeRequestUri;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.PrivilegedActionException;
import javax.security.auth.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationFilter.class);
    protected AuthenticationConfiguration authConfiguration;
    protected int timeout;
    private int pathIndex;

    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.authConfiguration = AuthenticationConfiguration.getConfiguration(servletContext);
        this.timeout = AuthSessionHelpers.getSessionTimeout(servletContext);
        this.pathIndex = ServletHelpers.hawtioPathIndex(servletContext);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.trace("Applying {}", (Object)this.getClass().getSimpleName());
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if ("OPTIONS".equals(httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        String path = httpRequest.getServletPath();
        LOG.debug("Handling request for path: {}", (Object)path);
        if (!this.authConfiguration.isEnabled() || this.authConfiguration.getRealm() == null || this.authConfiguration.getRealm().isEmpty()) {
            LOG.debug("No authentication needed for path: {}", (Object)path);
            chain.doFilter(request, response);
            return;
        }
        ProxyRequestType proxyMode = this.isProxyMode(httpRequest);
        if (proxyMode == ProxyRequestType.PROXY_ENABLED) {
            chain.doFilter(request, response);
            return;
        }
        HttpSession session = httpRequest.getSession(false);
        if (proxyMode == ProxyRequestType.PROXY && session == null) {
            ServletHelpers.doForbidden(httpResponse, ForbiddenReason.SESSION_EXPIRED);
            return;
        }
        if (session != null) {
            Subject subject2 = (Subject)session.getAttribute("subject");
            if (proxyMode == ProxyRequestType.PROXY) {
                if (subject2 != null) {
                    chain.doFilter(request, response);
                } else {
                    ServletHelpers.doForbidden(httpResponse);
                }
                return;
            }
            if (AuthSessionHelpers.validate(httpRequest, session, subject2)) {
                AuthenticationFilter.executeAs(request, response, chain, subject2);
                return;
            }
        }
        LOG.debug("Doing authentication and authorization for path: {}", (Object)path);
        AuthenticateResult result = new Authenticator(httpRequest, this.authConfiguration).authenticate(subject -> AuthenticationFilter.executeAs(request, response, chain, subject));
        switch (result.getType()) {
            case AUTHORIZED: {
                break;
            }
            case NOT_AUTHORIZED: {
                ServletHelpers.doForbidden(httpResponse);
                break;
            }
            case NO_CREDENTIALS: {
                if (this.authConfiguration.isNoCredentials401()) {
                    ServletHelpers.doAuthPrompt(httpResponse, this.authConfiguration.getRealm());
                    break;
                }
                ServletHelpers.doForbidden(httpResponse);
                break;
            }
            case THROTTLED: {
                ServletHelpers.doTooManyRequests(httpResponse, result.getRetryAfter());
            }
        }
    }

    protected ProxyRequestType isProxyMode(HttpServletRequest httpRequest) {
        ProxyRequestType proxyMode = ProxyRequestType.NOT_PROXY;
        RelativeRequestUri uri = new RelativeRequestUri(httpRequest, this.pathIndex);
        if (uri.getComponents().length > 0 && "proxy".equals(uri.getComponents()[0])) {
            proxyMode = uri.getUri().equals("proxy/enabled") ? ProxyRequestType.PROXY_ENABLED : ProxyRequestType.PROXY;
        }
        return proxyMode;
    }

    private static void executeAs(ServletRequest request, ServletResponse response, FilterChain chain, Subject subject) {
        try {
            Subject.doAs(subject, () -> {
                chain.doFilter(request, response);
                return null;
            });
        }
        catch (PrivilegedActionException e) {
            LOG.info("Failed to invoke action {} due to:", (Object)((HttpServletRequest)request).getPathInfo(), (Object)e);
        }
    }

    public void destroy() {
        LOG.info("Destroying hawtio authentication filter");
    }

    protected static enum ProxyRequestType {
        PROXY,
        PROXY_ENABLED,
        NOT_PROXY;

    }
}

