/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth.oidc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.proc.JWKSecurityContext;
import io.hawt.util.Strings;
import io.hawt.web.auth.RolePrincipal;
import io.hawt.web.auth.oidc.NopCookieStore;
import io.hawt.web.auth.oidc.OidcLoginModule;
import io.hawt.web.auth.oidc.token.ValidAccessToken;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.client.CookieStore;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcConfiguration
extends Configuration {
    public static final Logger LOG = LoggerFactory.getLogger(OidcConfiguration.class);
    public static final String OIDC_JAAS_CONFIGURATION = "OidcConfiguration";
    private URL providerURL;
    private String clientId;
    private ResponseMode responseMode;
    private String[] scopes;
    private URL redirectUri;
    private String codeChallengeMethod;
    private PromptType prompt;
    private String json;
    private AppConfigurationEntry[] jaasAppConfigurationEntries;
    private URL jwksURL;
    private final Set<String> supportedECCurves = Set.of("P-256", "P-384", "P-521");
    private final Map<String, PublicKey> publicKeys = new ConcurrentHashMap<String, PublicKey>();
    private volatile long cacheTime;
    private volatile long lastCheck = 0L;
    private CloseableHttpClient httpClient;
    private Class<? extends Principal> roleClass;
    private String rolesPathConfig;
    private String[] rolesPath;
    private final Map<String, String> roleMapping = new HashMap<String, String>();
    private JWKSecurityContext jwkContext;
    private boolean offline;

    public OidcConfiguration(Properties props) throws IOException {
        String rolesPath;
        String provider = props.getProperty("provider");
        if (Strings.isBlank(provider)) {
            return;
        }
        this.providerURL = new URL(provider);
        this.clientId = props.getProperty("client_id");
        this.responseMode = ResponseMode.fromString(props.getProperty("response_mode"));
        String redirectUri = props.getProperty("redirect_uri");
        if (Strings.isNotBlank(redirectUri)) {
            this.redirectUri = new URL(redirectUri);
        }
        this.codeChallengeMethod = props.getProperty("code_challenge_method");
        String scopes = props.getProperty("scope");
        this.scopes = scopes == null ? new String[0] : (String[])Arrays.stream(scopes.split("\\s+")).map(String::trim).toArray(String[]::new);
        this.prompt = PromptType.fromString(props.getProperty("prompt"));
        String jwksCacheTime = props.getProperty("jwks.cacheTime");
        if (jwksCacheTime != null) {
            try {
                int minutes = Integer.parseInt(jwksCacheTime);
                LOG.debug("Setting public key cache time to {} minutes", (Object)minutes);
                this.cacheTime = (long)(minutes * 60) * 1000L;
            }
            catch (NumberFormatException e) {
                LOG.warn("Illegal value of min-time-between-jwks-requests property. Defaulting to 60 minutes.");
                this.cacheTime = 3600000L;
            }
        }
        if ((rolesPath = props.getProperty("oidc.rolesPath")) == null || rolesPath.isBlank()) {
            LOG.info("No oidc.rolesPath configured. Defaults to \"roles\".");
            rolesPath = "roles";
        }
        this.rolesPathConfig = Strings.resolvePlaceholders(rolesPath, props);
        this.rolesPath = (String[])Arrays.stream(this.rolesPathConfig.split("\\.")).map(String::trim).toArray(String[]::new);
        for (String p : props.stringPropertyNames()) {
            if (!p.startsWith("roleMapping.")) continue;
            String jwtRole = p.substring("roleMapping.".length());
            String targetRole = props.getProperty(p);
            this.roleMapping.put(jwtRole, targetRole);
        }
        this.offline = this.booleanProperty(props, "offline", false);
        if (!this.offline) {
            this.buildHttpClient(props);
        }
        this.buildConfiguration(props);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        return this.jaasAppConfigurationEntries;
    }

    public URL getProviderURL() {
        return this.providerURL;
    }

    public String getClientId() {
        return this.clientId;
    }

    public ResponseMode getResponseMode() {
        return this.responseMode;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public URL getRedirectUri() {
        return this.redirectUri;
    }

    public String getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public PromptType getPrompt() {
        return this.prompt;
    }

    public String[] getRolesPath() {
        return this.rolesPath;
    }

    public Class<?> getRoleClass() {
        return this.roleClass;
    }

    public Map<String, String> getRoleMapping() {
        return this.roleMapping;
    }

    public PublicKey findPublicKey(String kid) {
        return this.publicKeys.get(kid);
    }

    public String toJSON() {
        return this.json;
    }

    private void buildHttpClient(Properties props) {
        SSLConnectionSocketFactory csf;
        int connectionTimeout = this.integerProperty(props, "http.connectionTimeout", 5000);
        int readTimeout = this.integerProperty(props, "http.readTimeout", 10000);
        String proxy = this.stringProperty(props, "http.proxyURL", null);
        String protocol = this.stringProperty(props, "ssl.protocol", "TLSv1.3");
        String truststore = this.stringProperty(props, "ssl.truststore", null);
        String truststorePassword = this.stringProperty(props, "ssl.truststorePassword", "");
        String keystore = this.stringProperty(props, "ssl.keystore", null);
        String keystorePassword = this.stringProperty(props, "ssl.keystorePassword", "");
        String keyAlias = this.stringProperty(props, "ssl.keyAlias", null);
        String keyPassword = this.stringProperty(props, "ssl.keyPassword", "");
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        requestConfigBuilder.setConnectTimeout(connectionTimeout);
        requestConfigBuilder.setSocketTimeout(readTimeout);
        SocketConfig.Builder socketConfigBuilder = SocketConfig.custom();
        socketConfigBuilder.setSoTimeout(readTimeout);
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        if (truststore == null && keystore == null) {
            csf = SSLConnectionSocketFactory.getSystemSocketFactory();
        } else {
            truststore = Strings.resolvePlaceholders(truststore);
            keystore = Strings.resolvePlaceholders(keystore);
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            sslContextBuilder.setProtocol(protocol);
            try {
                sslContextBuilder.loadTrustMaterial((TrustStrategy)null);
            }
            catch (KeyStoreException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Problem loading default truststore", e);
            }
            if (truststore != null) {
                try {
                    sslContextBuilder.loadTrustMaterial(new File(truststore), truststorePassword.toCharArray());
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw new IllegalArgumentException("Problem loading truststore from " + truststore, e);
                }
            }
            if (keystore != null) {
                try {
                    PrivateKeyStrategy pks = null;
                    if (keyAlias != null) {
                        pks = (aliases, socket) -> aliases.containsKey(keyAlias) ? keyAlias : null;
                    }
                    sslContextBuilder.loadKeyMaterial(new File(keystore), keystorePassword.toCharArray(), keyPassword.toCharArray(), pks);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    throw new IllegalArgumentException("Problem loading keystore from " + keystore, e);
                }
            }
            try {
                csf = new SSLConnectionSocketFactory(sslContextBuilder.build(), (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("Can't create SSL Socket Factory", e);
            }
        }
        Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)csf).build();
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultConnectionConfig(connectionConfigBuilder.build());
        connectionManager.setDefaultSocketConfig(socketConfigBuilder.build());
        connectionManager.setMaxTotal(20);
        connectionManager.setDefaultMaxPerRoute(connectionManager.getMaxTotal());
        HttpClientBuilder builder = HttpClients.custom();
        builder.useSystemProperties();
        builder.setDefaultCookieStore((CookieStore)new NopCookieStore());
        builder.setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
        builder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        if (proxy != null) {
            URI uri = URI.create(proxy);
            String scheme = uri.getScheme();
            String host = uri.getScheme();
            int port = uri.getPort();
            if (port <= 0) {
                if (scheme.equals("http")) {
                    port = 80;
                } else if (scheme.equals("https")) {
                    port = 443;
                } else {
                    LOG.warn("Invalid proxy definition: {}", (Object)proxy);
                }
            }
            if (port > 0) {
                builder.setProxy(new HttpHost(host, port, scheme));
            }
        }
        this.httpClient = builder.build();
    }

    private void buildConfiguration(Properties props) throws IOException {
        boolean fetchConfig;
        Object base;
        JSONObject json = new JSONObject();
        json.put("method", (Object)"oidc");
        if (this.providerURL != null) {
            json.put("provider", (Object)this.providerURL.toString());
        }
        json.put("client_id", (Object)this.clientId);
        if (this.responseMode != null) {
            json.put("response_mode", (Object)this.responseMode.asValue());
        }
        if (this.scopes != null) {
            json.put("scope", (Object)String.join((CharSequence)" ", this.scopes));
        }
        if (this.redirectUri != null) {
            json.put("redirect_uri", (Object)this.redirectUri.toString());
        }
        json.put("code_challenge_method", (Object)this.codeChallengeMethod);
        if (this.prompt != null) {
            json.put("prompt", (Object)this.prompt.asValue());
        }
        if (!((String)(base = this.providerURL.toString())).endsWith("/")) {
            base = (String)base + "/";
        }
        if (!(fetchConfig = this.booleanProperty(props, "oidc.cacheConfig", true)) || this.offline) {
            LOG.info("OpenID Connect configuration will not be loaded for {}", base);
        } else {
            URL configurationURL = new URL(new URL((String)base), ".well-known/openid-configuration");
            JSONObject openidConfiguration = this.fetchJSON(configurationURL);
            if (openidConfiguration == null) {
                LOG.error("Problem getting OpenID Connect configuration. OpenID/OAuth2 authentication disabled.");
                json = new JSONObject();
            } else {
                String jwksURI = openidConfiguration.getString("jwks_uri");
                if (jwksURI == null) {
                    LOG.error("No JWKS endpoint available - it is not possible to validate JWT access tokens. OpenID/OAuth2 authentication disabled.");
                    json = new JSONObject();
                } else {
                    URL url = new URL(jwksURI);
                    JSONObject jwksConfiguration = this.fetchJSON(url);
                    if (jwksConfiguration == null) {
                        LOG.error("Problem getting JWKS configuration - it is not possible to validate JWT access tokens. OpenID/OAuth2 authentication disabled.");
                        json = new JSONObject();
                    } else {
                        this.jwksURL = url;
                        this.cachePublicKeys(jwksConfiguration);
                        this.lastCheck = System.currentTimeMillis();
                    }
                }
            }
            if (this.jwksURL != null) {
                json.put("openid-configuration", (Object)openidConfiguration);
            }
        }
        this.json = json.toString();
        this.jaasAppConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry(OidcLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, Map.of(OIDC_JAAS_CONFIGURATION, this))};
    }

    public boolean isEnabled() {
        return this.getProviderURL() != null;
    }

    public JWKSecurityContext getJwkContext() {
        return this.jwkContext;
    }

    public void refreshPublicKeysIfNeeded() {
        JSONObject jwksConfiguration;
        if (this.lastCheck + this.cacheTime > System.currentTimeMillis()) {
            return;
        }
        if (this.jwksURL != null && (jwksConfiguration = this.fetchJSON(this.jwksURL)) != null) {
            this.cachePublicKeys(jwksConfiguration);
        }
        this.lastCheck = System.currentTimeMillis();
    }

    public void cachePublicKeys(JSONObject config) {
        this.publicKeys.clear();
        ArrayList<JWK> contextKeys = new ArrayList<JWK>();
        try {
            JSONArray keys = config.getJSONArray("keys");
            if (keys != null) {
                for (int k = 0; k < keys.length(); ++k) {
                    String y;
                    String crv;
                    String kid;
                    JSONObject key = keys.getJSONObject(k);
                    String type = key.has("kty") ? key.getString("kty") : null;
                    String string = kid = key.has("kid") ? key.getString("kid") : null;
                    if (type == null || kid == null) {
                        LOG.warn("Invalid key definition: {}", (Object)key.toString());
                        continue;
                    }
                    if ("RSA".equals(type)) {
                        String e;
                        String n = key.has("n") ? key.getString("n") : null;
                        String string2 = e = key.has("e") ? key.getString("e") : null;
                        if (n == null || e == null) {
                            LOG.warn("Invalid RSA key definition: {}", (Object)key.toString());
                            continue;
                        }
                        try {
                            JWK jwk = JWK.parse((Map)key.toMap());
                            if (jwk.getKeyUse() != KeyUse.SIGNATURE) continue;
                            this.cacheRSAKey(key);
                            contextKeys.add(jwk);
                        }
                        catch (ParseException ex) {
                            LOG.warn("Problem parsing RSA key: {}", (Object)ex.getMessage());
                        }
                        continue;
                    }
                    if (!"EC".equals(type)) continue;
                    String string3 = crv = key.has("crv") ? key.getString("crv") : null;
                    if (crv == null || !this.supportedECCurves.contains(crv)) {
                        LOG.warn("Unsupported \"crv\" parameter for EC key: {}", (Object)crv);
                        continue;
                    }
                    String x = key.has("x") ? key.getString("x") : null;
                    String string4 = y = key.has("y") ? key.getString("y") : null;
                    if (x == null || y == null) {
                        LOG.warn("Invalid EC key definition: {}", (Object)key.toString());
                        continue;
                    }
                    try {
                        JWK jwk = JWK.parse((Map)key.toMap());
                        if (jwk.getKeyUse() != KeyUse.SIGNATURE) continue;
                        this.cacheECKey(key, jwk.toECKey().toECPublicKey());
                        contextKeys.add(jwk);
                        continue;
                    }
                    catch (JOSEException | ParseException e) {
                        LOG.warn("Problem parsing EC key: {}", (Object)e.getMessage());
                    }
                }
            }
            this.jwkContext = new JWKSecurityContext(contextKeys);
        }
        catch (JSONException e) {
            LOG.error("Problem caching public keys: {}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject fetchJSON(URL url) {
        try {
            BasicHttpRequest get = new BasicHttpRequest("GET", url.toURI().toString());
            LOG.info("Fetching data: {}", (Object)get.getRequestLine());
            try (CloseableHttpResponse res = this.httpClient.execute(URIUtils.extractHost((URI)url.toURI()), (HttpRequest)get);){
                if (res.getStatusLine().getStatusCode() != 200) {
                    LOG.error("Invalid response from {}: {}", (Object)url, (Object)res.getStatusLine());
                    JSONObject jSONObject = null;
                    return jSONObject;
                }
                HttpEntity entity = res.getEntity();
                if (entity != null) {
                    ContentType ct = ContentType.get((HttpEntity)entity);
                    if (!ct.getMimeType().equals(ContentType.APPLICATION_JSON.getMimeType())) {
                        LOG.warn("Expected {}, got {}", (Object)ContentType.APPLICATION_JSON, (Object)ct);
                    } else {
                        JSONObject jSONObject = new JSONObject(EntityUtils.toString((HttpEntity)entity, (Charset)(ct.getCharset() == null ? Charset.defaultCharset() : ct.getCharset())));
                        return jSONObject;
                    }
                }
                JSONObject jSONObject = null;
                return jSONObject;
            }
        }
        catch (URISyntaxException e) {
            LOG.error("Problem with URI {}", (Object)url, (Object)e);
            return null;
        }
        catch (IOException e) {
            LOG.error("Problem connecting to {}", (Object)url, (Object)e);
            return null;
        }
    }

    private void cacheRSAKey(JSONObject key) {
        String kid = key.getString("kid");
        String nv = key.getString("n");
        String ev = key.getString("e");
        BigInteger n = new BigInteger(1, Base64.getUrlDecoder().decode(nv));
        BigInteger e = new BigInteger(1, Base64.getUrlDecoder().decode(ev));
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(n, e);
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            PublicKey publicKey = kf.generatePublic(publicKeySpec);
            this.publicKeys.put(kid, publicKey);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException ex) {
            LOG.warn("Can't cache RSA public key: {}", (Object)ex.getMessage());
        }
    }

    private void cacheECKey(JSONObject key, PublicKey publicKey) {
        String kid = key.getString("kid");
        this.publicKeys.put(kid, publicKey);
    }

    private int integerProperty(Properties props, String key, int defaultValue) {
        String v = props.getProperty(key);
        if (v == null || v.isBlank()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String stringProperty(Properties props, String key, String defaultValue) {
        String v = props.getProperty(key);
        if (v == null || v.isBlank()) {
            return defaultValue;
        }
        return v;
    }

    private boolean booleanProperty(Properties props, String key, boolean defaultValue) {
        String v = props.getProperty(key);
        if (v == null || v.isBlank()) {
            return defaultValue;
        }
        return v.equalsIgnoreCase("true");
    }

    public void setRolePrincipalClass(Class<? extends Principal> rolePrincipalClass) {
        this.roleClass = rolePrincipalClass == null ? RolePrincipal.class : rolePrincipalClass;
    }

    public String[] extractRoles(ValidAccessToken parsedToken) {
        LinkedHashSet<String> roles = new LinkedHashSet<String>();
        try {
            String[] actualRoles;
            Map claims = parsedToken.getJwt().getJWTClaimsSet().toJSONObject();
            String[] path = this.getRolesPath();
            for (int s = 0; s < path.length; ++s) {
                String segment = path[s];
                Object _claims = claims.get(segment);
                if (s < path.length - 1) {
                    if (!(_claims instanceof Map)) {
                        LOG.warn("Wrong roles path for JWT: {}", (Object)this.rolesPathConfig);
                        break;
                    }
                } else {
                    if (_claims instanceof String[]) {
                        roles.addAll(Arrays.asList((String[])_claims));
                        break;
                    }
                    if (_claims instanceof List) {
                        roles.addAll((List)_claims);
                        break;
                    }
                    LOG.warn("Wrong roles path for JWT: {}", (Object)this.rolesPathConfig);
                    break;
                }
                claims = (Map)_claims;
            }
            if ((actualRoles = new String[roles.size()]).length == 0) {
                return actualRoles;
            }
            int idx = 0;
            for (String role : roles) {
                actualRoles[idx++] = this.roleMapping.getOrDefault(role, role);
            }
            return actualRoles;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum ResponseMode {
        FRAGMENT("fragment"),
        QUERY("query");

        private final String mode;

        private ResponseMode(String mode) {
            this.mode = mode;
        }

        public static ResponseMode fromString(String value) {
            if (Strings.isNotBlank(value)) {
                for (ResponseMode rm : ResponseMode.values()) {
                    if (!rm.mode.equals(value)) continue;
                    return rm;
                }
            }
            return null;
        }

        public String asValue() {
            return this.mode;
        }
    }

    public static enum PromptType {
        NONE("none"),
        LOGIN("login"),
        CONSENT("consent"),
        SELECT_ACCOUNT("select_account");

        private final String mode;

        private PromptType(String mode) {
            this.mode = mode;
        }

        public static PromptType fromString(String value) {
            if (Strings.isNotBlank(value)) {
                for (PromptType rm : PromptType.values()) {
                    if (!rm.mode.equals(value)) continue;
                    return rm;
                }
            }
            return null;
        }

        public String asValue() {
            return this.mode;
        }
    }
}

