/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.web.auth.oidc;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWKSecurityContext;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import io.hawt.web.auth.RolePrincipal;
import io.hawt.web.auth.oidc.OidcConfiguration;
import io.hawt.web.auth.oidc.token.KidKeySelector;
import io.hawt.web.auth.oidc.token.ValidAccessToken;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcLoginModule
implements LoginModule {
    public static final Logger LOG = LoggerFactory.getLogger(OidcLoginModule.class);
    private Subject subject;
    private CallbackHandler callbackHandler;
    private OidcConfiguration oidcConfiguration;
    private ValidAccessToken parsedToken;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.oidcConfiguration = (OidcConfiguration)options.get("OidcConfiguration");
    }

    @Override
    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new NameCallback("username"), new PasswordCallback("password", false)};
        try {
            this.callbackHandler.handle(callbacks);
            String username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            String password = new String(tmpPassword);
            ((PasswordCallback)callbacks[1]).clearPassword();
            ValidAccessToken token = this.validateToken(password);
            if (token == null) {
                return false;
            }
            this.parsedToken = token;
            return true;
        }
        catch (IOException e) {
            LoginException loginException = new LoginException(e.getMessage());
            loginException.initCause(e);
            throw loginException;
        }
        catch (UnsupportedCallbackException e) {
            LOG.error("JAAS configuration error {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        catch (ParseException e) {
            LOG.error("JWT parse exception: {}", (Object)e.getMessage());
            LoginException loginException = new LoginException(e.getMessage());
            loginException.initCause(e);
            throw loginException;
        }
    }

    @Override
    public boolean commit() {
        if (this.parsedToken == null) {
            return false;
        }
        Class<?> clz = this.oidcConfiguration.getRoleClass();
        try {
            String[] roles;
            for (String role : roles = this.oidcConfiguration.extractRoles(this.parsedToken)) {
                Constructor<?> ctr = clz.getConstructor(String.class);
                this.subject.getPrincipals().add((Principal)ctr.newInstance(role));
            }
            this.subject.getPrivateCredentials().add(this.parsedToken.getAccessToken());
            return true;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.warn("Problem instantiating role principal for class {}", clz);
            return false;
        }
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject != null) {
            this.subject.getPrivateCredentials().clear();
            HashSet<Principal> principals = new HashSet<Principal>(this.subject.getPrincipals());
            principals.removeIf(p -> this.oidcConfiguration.getRoleClass().isAssignableFrom(p.getClass()) || RolePrincipal.class == p.getClass());
        }
        return true;
    }

    private ValidAccessToken validateToken(String token) throws ParseException {
        try {
            JWT jwt = JWTParser.parse((String)token);
            this.oidcConfiguration.refreshPublicKeysIfNeeded();
            JWKSecurityContext jwkContext = this.oidcConfiguration.getJwkContext();
            DefaultJWTProcessor processor = new DefaultJWTProcessor();
            processor.setJWSKeySelector((JWSKeySelector)new KidKeySelector());
            DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier(null, null, Set.of("sub"));
            processor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)claimsVerifier);
            processor.process(jwt, (SecurityContext)jwkContext);
            return new ValidAccessToken(jwt, token);
        }
        catch (ParseException e) {
            LOG.error("JWT parsing error", (Throwable)e);
        }
        catch (JOSEException | BadJOSEException e) {
            LOG.error("JWT processing error: {}", (Object)e.getMessage());
        }
        return null;
    }
}

