/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityResponse;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.AuthenticationProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class AuthenticationClientImpl
implements SecurityClient<AuthenticationResponse> {
    private final Security security;
    private final SecurityContextImpl context;
    private final SecurityRequest request;
    private final String providerName;

    AuthenticationClientImpl(Security security, SecurityContextImpl context, SecurityRequest request, String providerName) {
        this.security = security;
        this.context = context;
        this.request = request;
        this.providerName = providerName;
    }

    @Override
    public CompletionStage<AuthenticationResponse> submit() {
        return this.security.resolveAtnProvider(this.providerName).map(this::authenticate).orElseThrow(() -> new SecurityException("Could not find any authentication provider. Security is not configured")).thenCompose(authenticationResponse -> {
            CompletionStage<AuthenticationResponse> response = this.mapSubject((AuthenticationResponse)authenticationResponse);
            return response;
        });
    }

    private CompletionStage<AuthenticationResponse> mapSubject(AuthenticationResponse prevResponse) {
        ProviderRequest providerRequest = new ProviderRequest(this.context, this.request.getResources(), this.request.getRequestEntity(), this.request.getResponseEntity());
        if (prevResponse.getStatus() == SecurityResponse.SecurityStatus.SUCCESS) {
            return this.security.getSubjectMapper().map(mapper -> mapper.map(providerRequest, prevResponse)).orElseGet(() -> CompletableFuture.completedFuture(prevResponse)).thenApply(newResponse -> {
                if (newResponse == prevResponse) {
                    return prevResponse;
                }
                newResponse.getUser().ifPresent(this.context::setUser);
                newResponse.getService().ifPresent(this.context::setService);
                return newResponse;
            });
        }
        return CompletableFuture.completedFuture(prevResponse);
    }

    private CompletionStage<AuthenticationResponse> authenticate(AuthenticationProvider providerInstance) {
        ProviderRequest providerRequest = new ProviderRequest(this.context, this.request.getResources(), this.request.getRequestEntity(), this.request.getResponseEntity());
        return providerInstance.authenticate(providerRequest).thenApply(response -> {
            if (response.getStatus().isSuccess()) {
                response.getUser().ifPresent(this.context::setUser);
                response.getService().ifPresent(this.context::setService);
                this.context.audit(SecurityAuditEvent.success("authn.authenticate", "Provider %s. Subject %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("subject", response.getUser())));
                return response;
            }
            SecurityAuditEvent event = SecurityAuditEvent.failure("authn.authenticate", "Provider %s. Message: %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("message", response.getDescription().orElse(null)));
            response.getThrowable().map(e -> event.addParam(AuditEvent.AuditParam.plain("exception", response.getThrowable())));
            this.context.audit(event);
            return response;
        }).exceptionally(throwable -> {
            this.context.audit(SecurityAuditEvent.error("authn.authenticate", "Provider %s. Message: %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("message", throwable.getMessage())).addParam(AuditEvent.AuditParam.plain("exception", throwable)));
            throw new SecurityException((Throwable)throwable);
        });
    }
}

