/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.SecurityResponse;

public final class AuthorizationResponse
extends SecurityResponse {
    private static final AuthorizationResponse PERMIT_RESPONSE = ((Builder)AuthorizationResponse.builder().status(SecurityResponse.SecurityStatus.SUCCESS)).build();
    private static final AuthorizationResponse DENY_RESPONSE = ((Builder)AuthorizationResponse.builder().status(SecurityResponse.SecurityStatus.FAILURE)).build();
    private static final AuthorizationResponse ABSTAIN_RESPONSE = ((Builder)AuthorizationResponse.builder().status(SecurityResponse.SecurityStatus.ABSTAIN)).build();

    private AuthorizationResponse(Builder builder) {
        super(builder);
    }

    public static AuthorizationResponse permit() {
        return PERMIT_RESPONSE;
    }

    public static AuthorizationResponse deny() {
        return DENY_RESPONSE;
    }

    public static AuthorizationResponse abstain() {
        return ABSTAIN_RESPONSE;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isPermitted() {
        return this.getStatus().isSuccess();
    }

    public static class Builder
    extends SecurityResponse.SecurityResponseBuilder<Builder, AuthorizationResponse> {
        public AuthorizationResponse build() {
            return new AuthorizationResponse(this);
        }
    }
}

