/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.OptionalHelper;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.CompositeProviderFlag;
import io.helidon.security.CompositeProviderSelectionPolicy;
import io.helidon.security.ProviderRequest;
import io.helidon.security.SecurityResponse;
import io.helidon.security.Subject;
import io.helidon.security.spi.AuthenticationProvider;
import io.helidon.security.spi.ProviderConfig;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

final class CompositeAuthenticationProvider
implements AuthenticationProvider {
    private final List<Atn> providers = new LinkedList<Atn>();

    CompositeAuthenticationProvider(List<Atn> parts) {
        this.providers.addAll(parts);
    }

    @Override
    public Collection<Class<? extends Annotation>> supportedAnnotations() {
        HashSet<Class<? extends Annotation>> result = new HashSet<Class<? extends Annotation>>();
        this.providers.forEach(atnConfig -> result.addAll(((Atn)atnConfig).provider.supportedAnnotations()));
        return result;
    }

    @Override
    public Collection<String> supportedConfigKeys() {
        HashSet<String> configKeys = new HashSet<String>();
        this.providers.forEach(atnConfig -> configKeys.addAll(((Atn)atnConfig).provider.supportedConfigKeys()));
        return configKeys;
    }

    @Override
    public Collection<Class<? extends ProviderConfig>> supportedCustomObjects() {
        HashSet<Class<? extends ProviderConfig>> result = new HashSet<Class<? extends ProviderConfig>>();
        this.providers.forEach(atnConfig -> result.addAll(((Atn)atnConfig).provider.supportedCustomObjects()));
        return result;
    }

    @Override
    public Collection<String> supportedAttributes() {
        HashSet<String> result = new HashSet<String>();
        this.providers.forEach(atnConfig -> result.addAll(((Atn)atnConfig).provider.supportedAttributes()));
        return result;
    }

    @Override
    public CompletionStage<AuthenticationResponse> authenticate(ProviderRequest providerRequest) {
        CompletionStage<AuthenticationResponse> previous = CompletableFuture.completedFuture(AuthenticationResponse.abstain());
        for (Atn providerConfig : this.providers) {
            previous = previous.thenCombine(providerConfig.provider.authenticate(providerRequest), (prevRes, thisRes) -> this.processProvider(providerConfig, (AuthenticationResponse)prevRes, (AuthenticationResponse)thisRes));
        }
        return previous.exceptionally(throwable -> {
            Throwable cause = throwable.getCause();
            if (null == cause) {
                cause = throwable;
            }
            if (cause instanceof AsyncAtnException) {
                return ((AsyncAtnException)cause).response;
            }
            return AuthenticationResponse.failed("Failed processing: " + throwable.getMessage(), throwable);
        }).thenApply(authenticationResponse -> {
            if (authenticationResponse.getStatus() == SecurityResponse.SecurityStatus.ABSTAIN) {
                return AuthenticationResponse.abstain();
            }
            return authenticationResponse;
        });
    }

    private AuthenticationResponse processProvider(Atn providerConfig, AuthenticationResponse prevResponse, AuthenticationResponse thisResponse) {
        CompositeProviderFlag flag = providerConfig.config.getFlag();
        if (!flag.isValid(thisResponse.getStatus())) {
            switch (thisResponse.getStatus()) {
                case SUCCESS: 
                case SUCCESS_FINISH: 
                case ABSTAIN: {
                    AuthenticationResponse.Builder builder = AuthenticationResponse.builder();
                    builder.status(SecurityResponse.SecurityStatus.FAILURE);
                    builder.description("Composite flag forbids this response: " + (Object)((Object)thisResponse.getStatus()));
                    thisResponse.getDescription().map(builder::description);
                    thisResponse.getThrowable().map(builder::throwable);
                    throw new AsyncAtnException(builder.build());
                }
            }
            throw new AsyncAtnException(thisResponse);
        }
        if (flag == CompositeProviderFlag.SUFFICIENT && thisResponse.getStatus() == SecurityResponse.SecurityStatus.SUCCESS) {
            throw new AsyncAtnException(thisResponse);
        }
        if (prevResponse.getStatus() == SecurityResponse.SecurityStatus.ABSTAIN) {
            return thisResponse.getStatus().isSuccess() ? thisResponse : prevResponse;
        }
        if (!thisResponse.getStatus().isSuccess()) {
            return prevResponse;
        }
        AuthenticationResponse.Builder responseBuilder = AuthenticationResponse.builder();
        OptionalHelper.from(prevResponse.getUser().map(user -> this.combine((Subject)user, thisResponse.getUser()))).or(thisResponse::getUser).asOptional().ifPresent(responseBuilder::user);
        OptionalHelper.from(prevResponse.getService().map(service -> this.combine((Subject)service, thisResponse.getService()))).or(thisResponse::getService).asOptional().ifPresent(responseBuilder::service);
        return ((AuthenticationResponse.Builder)responseBuilder.status(SecurityResponse.SecurityStatus.SUCCESS)).build();
    }

    private Subject combine(Subject older, Optional<Subject> newSubject) {
        if (newSubject.isPresent()) {
            Subject newer = newSubject.get();
            return newer.combine(older);
        }
        return older;
    }

    static class Atn {
        private final CompositeProviderSelectionPolicy.FlaggedProvider config;
        private final AuthenticationProvider provider;

        Atn(CompositeProviderSelectionPolicy.FlaggedProvider config, AuthenticationProvider provider) {
            this.config = config;
            this.provider = provider;
        }
    }

    private static final class AsyncAtnException
    extends RuntimeException {
        private AuthenticationResponse response;

        private AsyncAtnException(AuthenticationResponse response) {
            this.response = response;
        }
    }
}

