/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.OptionalHelper;
import io.helidon.config.Config;
import io.helidon.security.AuditEvent;
import io.helidon.security.spi.AuditProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DefaultAuditProvider
implements AuditProvider {
    private final Logger auditLogger;

    private DefaultAuditProvider(String loggerName) {
        this.auditLogger = Logger.getLogger(loggerName);
    }

    public static DefaultAuditProvider fromConfig(Config config) {
        return new DefaultAuditProvider(config.get("security.audit.defaultProvider.logger").asString("AUDIT"));
    }

    @Override
    public Consumer<AuditProvider.TracedAuditEvent> getAuditConsumer() {
        return this::audit;
    }

    private void audit(AuditProvider.TracedAuditEvent event) {
        String tracingId = event.getTracingId();
        switch (event.getSeverity()) {
            case FAILURE: 
            case SUCCESS: 
            case INFO: {
                this.logEvent(tracingId, event, Level.FINEST);
                break;
            }
            case WARN: {
                this.logEvent(tracingId, event, Level.WARNING);
                break;
            }
            case ERROR: {
                this.logEvent(tracingId, event, Level.SEVERE);
                break;
            }
            default: {
                this.logEvent(tracingId, event, Level.SEVERE);
            }
        }
    }

    private void logEvent(String tracingId, AuditProvider.TracedAuditEvent event, Level level) {
        AuditProvider.AuditSource auditSource = event.getAuditSource();
        StringBuilder locationInfo = new StringBuilder();
        locationInfo.append(auditSource.getClassName().orElse("UnknownClass")).append(" ").append(auditSource.getMethodName().orElse("UnknownMethod")).append(" ").append(auditSource.getFileName().orElse("UnknownFile")).append(" ").append(auditSource.getLineNumber().orElse(-1));
        String msg = (Object)((Object)event.getSeverity()) + " " + event.getEventType() + " " + tracingId + " " + event.getClass().getSimpleName() + " " + locationInfo + " :: \"" + this.formatMessage(event) + "\"";
        String finalMsg = msg = msg.replace('\n', ' ');
        OptionalHelper.from(event.getThrowable()).ifPresentOrElse(throwable -> this.auditLogger.log(level, finalMsg, (Throwable)throwable), () -> this.auditLogger.log(level, finalMsg));
    }

    private String formatMessage(AuditEvent event) {
        return String.format(event.getMessageFormat(), this.toObjectParams(event.getParams()));
    }

    private Object[] toObjectParams(List<AuditEvent.AuditParam> parameters) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (AuditEvent.AuditParam param : parameters) {
            if (param.isSensitive()) {
                result.add(param.getName() + " (sensitive)");
                continue;
            }
            result.add(param.getValue().orElse("null"));
        }
        return result.toArray(new Object[0]);
    }
}

