/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.CollectionsHelper;
import io.helidon.config.Config;
import io.helidon.security.ClassToInstanceStore;
import io.helidon.security.util.AbacSupport;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class EndpointConfig
implements AbacSupport {
    private final Map<AnnotationScope, Map<Class<? extends Annotation>, List<Annotation>>> annotations;
    private final AbacSupport attributes;
    private final ClassToInstanceStore<Object> customObjects;
    private final Map<String, Config> configMap;

    private EndpointConfig(Builder builder) {
        this.annotations = Collections.unmodifiableMap(new EnumMap(builder.annotations));
        this.attributes = new AbacSupport.BasicAttributes((AbacSupport)builder.attributes);
        this.customObjects = new ClassToInstanceStore();
        this.customObjects.putAll(builder.customObjects);
        this.configMap = new HashMap<String, Config>(builder.configMap);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static EndpointConfig create() {
        return EndpointConfig.builder().build();
    }

    public Object getAttributeRaw(String key) {
        return this.attributes.getAttributeRaw(key);
    }

    public Collection<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    public <U> Optional<U> getInstance(Class<U> clazz) {
        return this.customObjects.getInstance(clazz);
    }

    public Collection<Class<?>> getInstanceKeys() {
        return this.customObjects.keys();
    }

    public Optional<Config> getConfig(String configKey) {
        return Optional.ofNullable(this.configMap.get(configKey));
    }

    public Map<Class<? extends Annotation>, List<Annotation>> getAnnotations(AnnotationScope ... scopes) {
        HashMap<Class<? extends Annotation>, List<Annotation>> result = new HashMap<Class<? extends Annotation>, List<Annotation>>();
        for (AnnotationScope scope : scopes) {
            Map<Class<? extends Annotation>, List<Annotation>> map = this.annotations.get((Object)scope);
            if (null == map) continue;
            map.forEach((annotClass, annotList) -> result.computeIfAbsent((Class<? extends Annotation>)annotClass, aClass -> new LinkedList()).addAll(annotList));
        }
        return result;
    }

    public <T extends Annotation> List<T> combineAnnotations(Class<T> annotationClass, AnnotationScope ... scopes) {
        LinkedList result = new LinkedList();
        result.addAll(this.getAnnotations(scopes).getOrDefault(annotationClass, CollectionsHelper.listOf()));
        return result;
    }

    public Builder derive() {
        Builder result = EndpointConfig.builder().attributes(this.attributes).customObjects(this.customObjects).configMap(this.configMap);
        this.annotations.forEach(result::annotations);
        return result;
    }

    public static final class Builder
    implements io.helidon.common.Builder<EndpointConfig> {
        private final Map<AnnotationScope, Map<Class<? extends Annotation>, List<Annotation>>> annotations = new EnumMap<AnnotationScope, Map<Class<? extends Annotation>, List<Annotation>>>(AnnotationScope.class);
        private final ClassToInstanceStore<Object> customObjects = new ClassToInstanceStore();
        private final Map<String, Config> configMap = new HashMap<String, Config>();
        private AbacSupport.BasicAttributes attributes = new AbacSupport.BasicAttributes();

        private Builder() {
        }

        public EndpointConfig build() {
            return new EndpointConfig(this);
        }

        public <U, V extends U> Builder customObject(Class<U> objectClass, V anObject) {
            this.customObjects.putInstance(objectClass, anObject);
            return this;
        }

        public Builder customObjects(ClassToInstanceStore<Object> customObjects) {
            this.customObjects.putAll(customObjects);
            return this;
        }

        public Builder config(String configKey, Config configuration) {
            this.configMap.put(configKey, configuration);
            return this;
        }

        public Builder configMap(Map<String, Config> configMap) {
            this.configMap.putAll(configMap);
            return this;
        }

        public Builder annotations(AnnotationScope scope, Map<Class<? extends Annotation>, List<Annotation>> annotations) {
            HashMap newAnnots = new HashMap();
            annotations.forEach((aClass, list) -> {
                if (!list.isEmpty()) {
                    Annotation annotation = (Annotation)list.get(0);
                    newAnnots.put(annotation.annotationType(), list);
                }
            });
            this.annotations.put(scope, newAnnots);
            return this;
        }

        private Builder attributes(AbacSupport attributes) {
            this.attributes = new AbacSupport.BasicAttributes(attributes);
            return this;
        }

        public Builder addAtribute(String key, Object value) {
            this.attributes.put(key, value);
            return this;
        }
    }

    public static enum AnnotationScope {
        APPLICATION,
        CLASS,
        METHOD,
        FIELD;

    }
}

