/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.util.AbacSupport;
import java.security.Principal;
import java.util.Collection;

public class Grant
implements AbacSupport,
Principal {
    private final AbacSupport properties;
    private final String type;
    private final String name;
    private final String origin;

    protected Grant(Builder<?> builder) {
        this.type = ((Builder)builder).type;
        this.name = ((Builder)builder).name;
        this.origin = ((Builder)builder).origin;
        AbacSupport.BasicAttributes properties = new AbacSupport.BasicAttributes((AbacSupport)((Builder)builder).properties);
        properties.put("type", (Object)this.type);
        properties.put("name", (Object)this.name);
        properties.put("origin", (Object)this.origin);
        this.properties = properties;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Object getAttributeRaw(String key) {
        return this.properties.getAttributeRaw(key);
    }

    public Collection<String> getAttributeNames() {
        return this.properties.getAttributeNames();
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.type + ":" + this.name;
    }

    public String getOrigin() {
        return this.origin;
    }

    public static class Builder<T extends Builder>
    implements io.helidon.common.Builder<Grant> {
        private AbacSupport.BasicAttributes properties = new AbacSupport.BasicAttributes();
        private String type;
        private String name;
        private String origin;
        private T instance = this;

        protected Builder() {
        }

        public Grant build() {
            return new Grant(this);
        }

        public T type(String type) {
            this.type = type;
            return this.instance;
        }

        public T name(String name) {
            this.name = name;
            return this.instance;
        }

        public T origin(String origin) {
            this.origin = origin;
            return this.instance;
        }

        public T attributes(AbacSupport attribs) {
            this.properties = new AbacSupport.BasicAttributes(attribs);
            return this.instance;
        }

        public T addAttribute(String key, Object value) {
            this.properties.put(key, value);
            return this.instance;
        }
    }
}

